/*
 * Decompiled with CFR 0.152.
 */
package gkappa.modernsplash;

import gkappa.modernsplash.ModernSplash;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import net.minecraft.launchwrapper.Launch;

public class TimeHistory {
    private static Properties config;
    private static File configFile;
    private static final Queue<Long> queue;

    public static long getEstimateTime() {
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        config = new Properties();
        try (InputStreamReader r = new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            config.load(r);
        }
        catch (IOException e) {
            ModernSplash.LOGGER.debug("Could not load time.history, will create a default one");
        }
        long sum = 0L;
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            long temp = TimeHistory.getLong(String.valueOf(i));
            if (temp > 0L) {
                ++count;
            }
            queue.add(temp);
            sum += temp;
        }
        return sum == 0L ? 0L : sum / (long)count;
    }

    public static void saveHistory(long time) {
        queue.add(time);
        queue.remove();
        int i = 0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            config.setProperty(String.valueOf(i++), Long.toString(l));
        }
        try (OutputStreamWriter w = new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            config.store(w, "Launch time history");
        }
        catch (IOException e) {
            ModernSplash.LOGGER.debug("Could not save the time.history file", (Throwable)e);
        }
    }

    private static long getLong(String name) {
        String value = config.getProperty(name, Long.toString(0L));
        config.setProperty(name, value);
        return Long.decode(value);
    }

    static {
        configFile = new File(Launch.minecraftHome, "config/time.history");
        queue = new LinkedList<Long>();
    }
}

