/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block.buzzybees;

import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.registry.FSounds;
import thedarkcolour.futuremc.tile.BeeHiveTile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u0014"}, d2={"Lthedarkcolour/futuremc/block/buzzybees/ShearDispenserBehaviour;", "Lnet/minecraft/init/Bootstrap$BehaviorDispenseOptional;", "()V", "dispense", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "source", "Lnet/minecraft/dispenser/IBlockSource;", "stack", "existing", "Lnet/minecraft/dispenser/IBehaviorDispenseItem;", "shearBeehive", "", "worldIn", "pos", "Lnet/minecraft/util/math/BlockPos;", "shearSheep", "Lnet/minecraft/world/WorldServer;", "shears", "Future-MC"})
public final class ShearDispenserBehaviour
extends Bootstrap.BehaviorDispenseOptional {
    @NotNull
    public static final ShearDispenserBehaviour INSTANCE;

    @NotNull
    public final ItemStack dispense(@NotNull World world, @NotNull IBlockSource source, @NotNull ItemStack stack, @Nullable IBehaviorDispenseItem existing) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IBlockState state = source.func_189992_e();
        if (!world.field_72995_K) {
            BlockPos pos;
            BlockPos blockPos = pos = source.func_180699_d().func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockDispenser.field_176441_a));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
            boolean bl = this.field_190911_b = this.shearBeehive(world, blockPos) || this.shearSheep((WorldServer)world, pos, stack);
            if (!this.field_190911_b && existing != null) {
                return stack;
            }
            if (this.field_190911_b && stack.func_96631_a(1, world.field_73012_v, null)) {
                stack.func_190920_e(0);
            }
        }
        this.func_82485_a(source);
        this.func_82489_a(source, (EnumFacing)state.func_177229_b((IProperty)BlockDispenser.field_176441_a));
        return stack;
    }

    private final boolean shearBeehive(World worldIn, BlockPos pos) {
        int honeyLevel;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof BeeHiveTile && (honeyLevel = ((BeeHiveTile)tile).getHoneyLevel()) >= 5) {
            worldIn.func_184133_a(null, pos, FSounds.INSTANCE.getBEEHIVE_SHEAR(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            ((BeeHiveTile)tile).dropHoneyCombs(worldIn, pos);
            ((BeeHiveTile)tile).emptyHoney(worldIn, pos, null);
            return true;
        }
        return false;
    }

    private final boolean shearSheep(WorldServer worldIn, BlockPos pos, ItemStack shears) {
        for (EntityLiving entity : worldIn.func_72872_a(EntityLiving.class, new AxisAlignedBB(pos))) {
            if (!(entity instanceof IShearable) || !((IShearable)entity).isShearable(shears, (IBlockAccess)worldIn, pos)) continue;
            List list2 = ((IShearable)entity).onSheared(shears, (IBlockAccess)worldIn, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)shears));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"entity.onSheared(shears,\u2026ntments.FORTUNE, shears))");
            List drops = list2;
            Random rand = worldIn.field_73012_v;
            for (ItemStack stack : drops) {
                float f = 0.7f;
                EntityItem itemEntity = new EntityItem((World)worldIn, (double)((float)pos.func_177958_n() + rand.nextFloat() * f) + (double)(1.0f - f) * 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat() * f) + (double)(1.0f - f) * 0.5, (double)((float)pos.func_177952_p() + rand.nextFloat() * f) + (double)(1.0f - f) * 0.5, stack);
                itemEntity.func_174869_p();
                worldIn.func_72838_d((Entity)itemEntity);
            }
            return true;
        }
        return false;
    }

    private ShearDispenserBehaviour() {
    }

    static {
        ShearDispenserBehaviour shearDispenserBehaviour;
        INSTANCE = shearDispenserBehaviour = new ShearDispenserBehaviour();
    }
}

