/*
 * Decompiled with CFR 0.152.
 */
package superbas11.menumobs;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import superbas11.menumobs.MenuMobs;
import superbas11.menumobs.Reference;
import superbas11.menumobs.client.util.EntityUtils;
import superbas11.menumobs.client.util.UUIDFetcher;
import superbas11.menumobs.util.FakeNetHandlerPlayClient;
import superbas11.menumobs.util.FakeWorld;
import superbas11.menumobs.util.LogHelper;

@SideOnly(value=Side.CLIENT)
public class MainMenuRenderTicker {
    private static Minecraft mcClient;
    private static boolean isRegistered;
    private static Set<String> entityBlacklist;
    private static List<AbstractMap.SimpleEntry<UUID, String>> fallbackPlayerNames;
    private static ItemStack[] playerItems;
    private static ItemStack[] zombieItems;
    private static ItemStack[] horseArmors;
    private static ItemStack[] skelItems;
    private static Random random;
    private static String[] entStrings;
    private static int id;
    private static boolean erroredOut;
    private WorldClient world;
    private EntityLivingBase randMob;
    private EntityPlayerSP player;

    public MainMenuRenderTicker() {
        mcClient = FMLClientHandler.instance().getClient();
    }

    private static EntityLivingBase getNextEntity(World world) {
        Class clazz;
        int tries = 0;
        do {
            if (++id < entStrings.length) continue;
            id = 0;
        } while (!EntityLivingBase.class.isAssignableFrom(clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(entStrings[id]))) && ++tries <= 5);
        if (!EntityLivingBase.class.isAssignableFrom(clazz)) {
            return MainMenuRenderTicker.getRandomPlayer(world);
        }
        if (MenuMobs.instance.allowDebugOutput) {
            LogHelper.info(entStrings[id], new Object[0]);
        }
        return (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entStrings[id]), (World)world);
    }

    private static EntityLivingBase getFixedEntity(World world) {
        int id;
        String[] entityList = MenuMobs.instance.fixedMob;
        Object entity = null;
        Random random = new Random();
        int tries = 0;
        do {
            Class clazz;
            if ((clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(entityList[id = random.nextInt(entityList.length)]))) == null) {
                try {
                    UUID UUID2 = UUIDFetcher.getUUIDOf(entityList[id]);
                    if (UUID2 == null) {
                        LogHelper.warning("Entity " + entityList[id] + " is unknown!", new Object[0]);
                        continue;
                    }
                    GameProfile gameProfile = mcClient.func_152347_ac().fillProfileProperties(new GameProfile(UUID2, entityList[id]), true);
                    final NetworkPlayerInfo networkPlayerInfo = new NetworkPlayerInfo(gameProfile);
                    entity = new EntityOtherPlayerMP(world, gameProfile){

                        protected NetworkPlayerInfo func_175155_b() {
                            return networkPlayerInfo;
                        }
                    };
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            entity = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityList[id]), (World)world);
        } while (entity == null && ++tries < entityList.length);
        if (entity == null) {
            LogHelper.warning("Using fallback!", new Object[0]);
            return EntityUtils.getRandomLivingEntity(world, entityBlacklist, 5, fallbackPlayerNames);
        }
        if (MenuMobs.instance.allowDebugOutput) {
            LogHelper.info(entityList[id], new Object[0]);
        }
        return entity;
    }

    private static void setRandomMobProperties(EntityLivingBase ent) {
        if (ent instanceof EntitySheep) {
            ((EntitySheep)ent).func_175512_b(EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)]);
        } else if (ent instanceof EntityVillager) {
            ((EntityVillager)ent).func_70938_b(random.nextInt(5));
        } else if (ent instanceof EntityRabbit) {
            int i = random.nextInt(13);
            ((EntityRabbit)ent).func_175529_r(i < 12 ? (i % 2 == 0 ? i / 2 : (i - 1) / 2) : 99);
        } else if (Loader.isModLoaded((String)"chickens")) {
            try {
                Class<?> EntityChickensChicken = Class.forName("com.setycz.chickens.chicken.EntityChickensChicken");
                if (EntityChickensChicken.isInstance(ent)) {
                    Method getItems = Class.forName("com.setycz.chickens.ChickensRegistry").getMethod("getItems", new Class[0]);
                    List<Integer> chickens = MainMenuRenderTicker.getChickenTypes((Collection)getItems.invoke(null, new Object[0]));
                    EntityChickensChicken.getMethod("setChickenType", Integer.TYPE).invoke((Object)ent, chickens.get(random.nextInt(chickens.size())));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setRandomMobItem(EntityLivingBase ent) {
        try {
            if (ent instanceof AbstractClientPlayer) {
                ent.func_184611_a(EnumHand.MAIN_HAND, playerItems[random.nextInt(playerItems.length)]);
            } else if (ent instanceof EntityPigZombie) {
                ent.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151010_B));
            } else if (ent instanceof EntityZombie) {
                ent.func_184611_a(EnumHand.MAIN_HAND, zombieItems[random.nextInt(zombieItems.length)]);
            } else if (ent instanceof AbstractChestHorse) {
                ((AbstractChestHorse)ent).func_110207_m(random.nextBoolean());
            } else if (ent instanceof EntitySkeleton || ent instanceof EntityStray) {
                ent.func_184611_a(EnumHand.MAIN_HAND, skelItems[random.nextInt(skelItems.length)]);
            } else if (ent instanceof EntityWitherSkeleton) {
                ent.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151010_B));
            } else if (ent instanceof EntityEnderman) {
                Object[] blocks = EntityEnderman.field_70827_d.toArray();
                IBlockState block = ((Block)blocks[random.nextInt(blocks.length)]).func_176223_P();
                ((EntityEnderman)ent).func_175490_a(block);
            } else if (ent instanceof EntityHorse) {
                int baseColor = random.nextInt(7);
                int markings = random.nextInt(5);
                ((EntityHorse)ent).func_110235_q(baseColor | markings << 8);
                if (random.nextBoolean()) {
                    ((EntityHorse)ent).func_110251_o(true);
                    ((EntityHorse)ent).func_146086_d(horseArmors[random.nextInt(horseArmors.length)]);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static EntityOtherPlayerMP getRandomPlayer(World world) {
        AbstractMap.SimpleEntry<UUID, String> entry = fallbackPlayerNames.get(random.nextInt(fallbackPlayerNames.size()));
        GameProfile gameProfile = mcClient.func_152347_ac().fillProfileProperties(new GameProfile(entry.getKey(), entry.getValue()), true);
        final NetworkPlayerInfo networkPlayerInfo = new NetworkPlayerInfo(gameProfile);
        return new EntityOtherPlayerMP(world, gameProfile){

            protected NetworkPlayerInfo func_175155_b() {
                return networkPlayerInfo;
            }
        };
    }

    public static String[] getEntStrings() {
        return entStrings;
    }

    @Optional.Method(modid="chickens")
    private static List<Integer> getChickenTypes(Collection chickens) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Class<?> ChickensRegistryItem = Class.forName("com.setycz.chickens.ChickensRegistryItem");
        for (Object chicken : chickens) {
            result.add((Integer)ChickensRegistryItem.getMethod("getId", new Class[0]).invoke(chicken, new Object[0]));
        }
        return result;
    }

    private void drawBlacklistButton(int mouseX, int mouseY) {
        mcClient.func_110434_K().func_110577_a(new ResourceLocation("fml:textures/gui/icons.png"));
        GlStateManager.func_179097_i();
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)40.0f, (int)8, (int)8, (float)128.0f, (float)128.0f);
        if (mouseX < 8 && mouseY < 8) {
            GuiUtils.drawHoveringText(Collections.singletonList("Add mob to the blacklist"), (int)mouseX, (int)(mouseY + 20), (int)MainMenuRenderTicker.mcClient.field_71462_r.field_146294_l, (int)MainMenuRenderTicker.mcClient.field_71462_r.field_146295_m, (int)(MainMenuRenderTicker.mcClient.field_71462_r.field_146294_l / 2), (FontRenderer)MainMenuRenderTicker.mcClient.field_71466_p);
            GlStateManager.func_179140_f();
            GlStateManager.func_179117_G();
        }
        GlStateManager.func_179126_j();
    }

    private void drawNextButton(int mouseX, int mouseY) {
        int XOffset = 9;
        mcClient.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/world_selection.png"));
        GlStateManager.func_179097_i();
        if (this.randMob instanceof EntityOtherPlayerMP) {
            XOffset = 0;
        }
        if (mouseX > XOffset && mouseX < 6 + XOffset && mouseY < 8) {
            Gui.func_146110_a((int)(XOffset + 1), (int)0, (float)4.0f, (float)14.0f, (int)6, (int)9, (float)96.0f, (float)96.0f);
            GuiUtils.drawHoveringText(Collections.singletonList("Next mob"), (int)mouseX, (int)(mouseY + 20), (int)MainMenuRenderTicker.mcClient.field_71462_r.field_146294_l, (int)MainMenuRenderTicker.mcClient.field_71462_r.field_146295_m, (int)(MainMenuRenderTicker.mcClient.field_71462_r.field_146294_l / 2), (FontRenderer)MainMenuRenderTicker.mcClient.field_71466_p);
            GlStateManager.func_179140_f();
            GlStateManager.func_179117_G();
        } else {
            Gui.func_146110_a((int)(XOffset + 1), (int)0, (float)4.0f, (float)2.0f, (int)6, (int)9, (float)96.0f, (float)96.0f);
        }
        GlStateManager.func_179126_j();
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (Loader.isModLoaded((String)"WorldStateCheckpoints")) {
            MenuMobs.instance.showMainMenuMobs = false;
            LogHelper.severe("Main menu mob rendering is known to cause crashes with WorldStateCheckpoints and has been disabled for the remainder of this session.", new Object[0]);
            this.unRegister();
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (MenuMobs.instance.showMainMenuMobs && !erroredOut && this.isMainMenu(MainMenuRenderTicker.mcClient.field_71462_r)) {
            try {
                if (this.player == null || this.player.field_70170_p == null || this.randMob == null) {
                    this.init();
                }
                if (MainMenuRenderTicker.mcClient.func_175598_ae().field_78722_g == null || MainMenuRenderTicker.mcClient.func_175598_ae().field_78734_h == null) {
                    mcClient.func_175598_ae().func_180597_a((World)this.world, MainMenuRenderTicker.mcClient.field_71466_p, (Entity)this.player, (Entity)this.player, MainMenuRenderTicker.mcClient.field_71474_y, 0.0f);
                }
                if (this.world != null && this.player != null && this.randMob != null) {
                    MainMenuRenderTicker.mcClient.field_71439_g = this.player;
                    MainMenuRenderTicker.mcClient.field_71441_e = this.world;
                    ScaledResolution sr = new ScaledResolution(mcClient);
                    int mouseX = Mouse.getX() * sr.func_78326_a() / MainMenuRenderTicker.mcClient.field_71443_c;
                    int mouseY = sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / MainMenuRenderTicker.mcClient.field_71440_d - 1;
                    int distanceToSide = (MainMenuRenderTicker.mcClient.field_71462_r.field_146294_l / 2 - 98) / 2;
                    float targetHeight = (float)(sr.func_78324_d() / 5.0) / 1.8f;
                    float scale = EntityUtils.getEntityScale(this.randMob, targetHeight, 1.8f);
                    EntityUtils.drawEntityOnScreen(distanceToSide, (int)((float)(sr.func_78328_b() / 2) + this.randMob.field_70131_O * scale), scale, distanceToSide - mouseX, (float)(sr.func_78328_b() / 2) + this.randMob.field_70131_O * scale - this.randMob.field_70131_O * scale * (this.randMob.func_70047_e() / this.randMob.field_70131_O) - (float)mouseY, this.randMob);
                    EntityUtils.drawEntityOnScreen(sr.func_78326_a() - distanceToSide, (int)((float)(sr.func_78328_b() / 2) + this.player.field_70131_O * targetHeight), targetHeight, sr.func_78326_a() - distanceToSide - mouseX, (float)(sr.func_78328_b() / 2) + this.player.field_70131_O * targetHeight - this.player.field_70131_O * targetHeight * (this.player.func_70047_e() / this.player.field_70131_O) - (float)mouseY, (EntityLivingBase)this.player);
                    if (!(this.randMob instanceof EntityOtherPlayerMP)) {
                        this.drawBlacklistButton(mouseX, mouseY);
                    }
                    this.drawNextButton(mouseX, mouseY);
                }
            }
            catch (Throwable e) {
                LogHelper.severe("Main menu mob rendering encountered a serious error and has been disabled for the remainder of this session.", new Object[0]);
                e.printStackTrace();
                erroredOut = true;
                this.player = null;
                this.randMob = null;
                this.world = null;
            }
            MainMenuRenderTicker.mcClient.field_71439_g = null;
            MainMenuRenderTicker.mcClient.field_71441_e = null;
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Post event) {
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && this.randMob != null) {
            ScaledResolution sr = new ScaledResolution(mcClient);
            int mouseX = Mouse.getX() * sr.func_78326_a() / MainMenuRenderTicker.mcClient.field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / MainMenuRenderTicker.mcClient.field_71440_d - 1;
            boolean isPlayer = this.randMob instanceof EntityOtherPlayerMP;
            if (mouseX < 8 && mouseY < 8 && !isPlayer) {
                HashSet<String> blacklist = new HashSet<String>(Arrays.asList(MenuMobs.instance.blacklist.getStringList()));
                blacklist.add(EntityList.func_191301_a((Entity)this.randMob).toString());
                MenuMobs.instance.blacklist.set(blacklist.toArray(new String[0]));
                Reference.config.save();
                this.randMob = null;
            } else if ((mouseX < 8 && isPlayer || mouseX > 9 && mouseX < 15 && !isPlayer) && mouseY < 8) {
                this.randMob = null;
            }
        }
    }

    @SubscribeEvent
    public void onGameTick(TickEvent.ClientTickEvent event) {
        if (this.world != null && this.randMob != null && this.player != null && event.phase == TickEvent.Phase.START) {
            MainMenuRenderTicker.mcClient.field_71439_g = this.player;
            this.world.func_72870_g((Entity)this.randMob);
            this.world.func_72870_g((Entity)this.player);
            if (this.randMob instanceof EntityLiving && MenuMobs.instance.mobSoundVolume > 0.0 && this.randMob.func_70089_S()) {
                if (random.nextInt(1000) < ((EntityLiving)this.randMob).field_70757_a++) {
                    ((EntityLiving)this.randMob).field_70757_a = -((EntityLiving)this.randMob).func_70627_aG();
                    ((EntityLiving)this.randMob).func_70642_aH();
                }
            }
            MainMenuRenderTicker.mcClient.field_71439_g = null;
        }
    }

    private void init() {
        try {
            boolean createNewWorld = this.world == null;
            WorldSettings worldSettings = new WorldSettings(0L, GameType.NOT_SET, true, false, WorldType.field_77137_b);
            FakeNetHandlerPlayClient netHandler = new FakeNetHandlerPlayClient(mcClient);
            if (createNewWorld) {
                this.world = new FakeWorld(worldSettings, netHandler);
            }
            if (createNewWorld || this.player == null) {
                this.player = new EntityPlayerSP(mcClient, (World)this.world, (NetHandlerPlayClient)netHandler, null, null);
                int ModelParts = 0;
                for (EnumPlayerModelParts enumplayermodelparts : MainMenuRenderTicker.mcClient.field_71474_y.func_178876_d()) {
                    ModelParts |= enumplayermodelparts.func_179327_a();
                }
                this.player.func_184212_Q().func_187227_b(EntityPlayer.field_184827_bp, (Object)((byte)ModelParts));
                this.player.func_184819_a(MainMenuRenderTicker.mcClient.field_71474_y.field_186715_A);
                this.player.field_71093_bK = 0;
                this.player.field_71158_b = new MovementInputFromOptions(MainMenuRenderTicker.mcClient.field_71474_y);
                this.player.eyeHeight = 1.82f;
                MainMenuRenderTicker.setRandomMobItem((EntityLivingBase)this.player);
            }
            if (createNewWorld || this.randMob == null) {
                if (MenuMobs.instance.fixedMob.length > 0) {
                    this.randMob = MainMenuRenderTicker.getFixedEntity((World)this.world);
                } else if (MenuMobs.instance.showOnlyPlayerModels) {
                    this.randMob = MainMenuRenderTicker.getRandomPlayer((World)this.world);
                } else if (MenuMobs.instance.allowDebugOutput) {
                    this.randMob = MainMenuRenderTicker.getNextEntity((World)this.world);
                } else {
                    HashSet<String> blacklist = new HashSet<String>(entityBlacklist);
                    blacklist.addAll(Arrays.asList(MenuMobs.instance.blacklist.getStringList()));
                    this.randMob = EntityUtils.getRandomLivingEntity((World)this.world, blacklist, 4, fallbackPlayerNames);
                }
                if (this.randMob instanceof EntityPlayer) {
                    this.randMob.func_184212_Q().func_187227_b(EntityPlayer.field_184827_bp, (Object)127);
                }
                MainMenuRenderTicker.setRandomMobProperties(this.randMob);
                MainMenuRenderTicker.setRandomMobItem(this.randMob);
            }
            EntityUtils.updateLightmap(mcClient, (World)this.world);
            mcClient.func_175598_ae().func_180597_a((World)this.world, MainMenuRenderTicker.mcClient.field_71466_p, (Entity)this.player, (Entity)this.player, MainMenuRenderTicker.mcClient.field_71474_y, 0.0f);
        }
        catch (Throwable e) {
            LogHelper.severe("Main menu mob rendering encountered a serious error and has been disabled for the remainder of this session.", new Object[0]);
            e.printStackTrace();
            erroredOut = true;
            this.player = null;
            this.randMob = null;
            this.world = null;
        }
    }

    public void register() {
        if (!isRegistered) {
            LogHelper.info("Enabling Main Menu Mob render ticker", new Object[0]);
            MinecraftForge.EVENT_BUS.register((Object)this);
            isRegistered = true;
        }
    }

    public void unRegister() {
        if (isRegistered) {
            LogHelper.info("Disabling Main Menu Mob render ticker", new Object[0]);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            isRegistered = false;
            this.randMob = null;
            this.world = null;
            this.player = null;
        }
    }

    public boolean isRegistered() {
        return isRegistered;
    }

    public boolean isMainMenu(GuiScreen gui) {
        if (gui == null) {
            return false;
        }
        if (gui instanceof GuiMainMenu) {
            return true;
        }
        if (Loader.isModLoaded((String)"custommainmenu")) {
            boolean flag;
            try {
                flag = gui.getClass().getCanonicalName().equalsIgnoreCase("lumien.custommainmenu.gui.GuiCustom");
            }
            catch (Exception e) {
                flag = false;
            }
            return flag;
        }
        return false;
    }

    static {
        isRegistered = false;
        random = new Random();
        erroredOut = false;
        entityBlacklist = new HashSet<String>();
        entityBlacklist.add("minecraft:lightning_bolt");
        entityBlacklist.add("minecraft:ender_dragon");
        entityBlacklist.add("minecraft:squid");
        entityBlacklist.add("minecraft:ghast");
        entityBlacklist.add("minecraft:bat");
        entityBlacklist.add("minecraft:cave_spider");
        entityBlacklist.add("minecraft:giant");
        entityBlacklist.add("minecraft:elder_guardian");
        entityBlacklist.add("minecraft:guardian");
        entityBlacklist.add("MillBlaze");
        entityBlacklist.add("MillGhast");
        entityBlacklist.add("MillWitherSkeleton");
        entityBlacklist.add("ml_GenericAsimmFemale");
        entityBlacklist.add("ml_GenericSimmFemale");
        entityBlacklist.add("ml_GenericVillager");
        entityBlacklist.add("thaumcraft:firebat");
        entityBlacklist.add("thaumcraft:taintSwarm");
        entityBlacklist.add("thaumcraft:taintspore");
        entityBlacklist.add("thaumcraft:taintacle");
        entityBlacklist.add("thaumcraft:taintacletiny");
        entityBlacklist.add("thaumcraft:wisp");
        entityBlacklist.add("twilightforest:boggard");
        entityBlacklist.add("twilightforest:firefly");
        entityBlacklist.add("twilightforest:helmet_crab");
        entityBlacklist.add("twilightforest:hydra");
        entityBlacklist.add("twilightforest:hydra_head");
        entityBlacklist.add("twilightforest:goblin_knight_lower");
        entityBlacklist.add("twilightforest:mist_wolf");
        entityBlacklist.add("twilightforest:mosquito_swarm");
        entityBlacklist.add("twilightforest:snow_guardian");
        entityBlacklist.add("twilightforest:goblin_knight_upper");
        entityBlacklist.add("twilightforest:knight_phantom");
        entityBlacklist.add("headcrumbs:Human");
        entityBlacklist.add("thuttech:thuttechlift");
        entityBlacklist.add("evilcraft:vengeanceSpirit");
        entityBlacklist.add("minecolonies:citizen");
        entityBlacklist.add("draconicevolution:guardiancrystal");
        entityBlacklist.add("draconicevolution:chaosguardian");
        entityBlacklist.add("computronics:swarm");
        entityBlacklist.add("biomesoplenty:phantom");
        entityBlacklist.add("forestry:butterflyge");
        entityBlacklist.add("tConstruct:crystal");
        entityBlacklist.add("cyclicmagic:magic_missile");
        entityBlacklist.add("astralsorcery:entityflare");
        entityBlacklist.add("astralsorcery:entityspectraltool");
        fallbackPlayerNames = new ArrayList<AbstractMap.SimpleEntry<UUID, String>>();
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"41834a728902449586b8731b1c253afe"), "superbas11"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"92d459067a50474285b6b079db9dc189"), "bspkrs"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"2efa46fa29484d98b822fa182d254870"), "lorddusk"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"b9a89002b3924545ab4d5b1ff60c88a6"), "Arkember"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"48a16fc8bc1f4e7284e97ec73b7d8ea1"), "TTFTCUTS"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"95fe0728e1bd4989a9803d8976aedda9"), "WayofFlowingTime"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"e6b5c088068044df9e1b9bf11792291b"), "Grumm"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"af1d579e8787433099b2e7b3777c3e7a"), "Sacheverell"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"4c13e7d20e854bdebb121a43be506302"), "Quetzz"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"0192723fb3dc495a959f52c53fa63bff"), "Pahimar"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"f46302d20b7c4cc6aee9cd714ae6b9d1"), "ZeldoKavira"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"0eff7eb1d1b74612a9c9791b7ad6277a"), "sfPlayer1"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"c7d5d58a51a84d2698f55550a37bd8d1"), "jadedcat"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"72ddaa057bbe4ae298922c8d90ea0ad8"), "RWTema"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"754e416456cc4139bb7911cfaafdebcc"), "Scottwears"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"7ef08b4e5f3d40a793d426a19fe0efe2"), "neptunepink"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"90201c8957124f99a1c95d751565560a"), "Aureylian"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"bbb87dbe690f4205bdc572ffb8ebc29d"), "direwolf20"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"d0719201af1d4aab93d0f514ab59ed8e"), "Krystal_Raven"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"069a79f444e94726a5befca90e38aaf5"), "Notch"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"61699b2ed3274a019f1e0ea8c3f06bc6"), "Dinnerbone"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"e358f2774a4c42f69ad83addf4869ea6"), "Adubbz"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"892017ede9a04f259a37b8811614707d"), "AlgorithmX2"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"6d074736b1e94378a99bbd8777821c9c"), "Cloudhunter"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"3af4f9617eb64cb0b26443fd593cf42a"), "Lunatrius"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"75831c039a0a496ba7776a78ef8833a6"), "_Sunstrike"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"b72d87cefa984a5ab5a05db51a018d09"), "sdkillen"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"af1483804ba54a3da47d710f710f9265"), "Minalien"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"6bdd4acd5637448898583de07cc820d5"), "futureamnet"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"8e32d7a9c8124fa78daf465ff9ffa262"), "AbrarSyed"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"6ac7c57d8c154ffeae5d5e04bd606786"), "TDWP_FTW"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"d3cf097a438f4523b770ec11e13ecc32"), "LexManos"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"98beecaf555e40649401b531fb927641"), "Vaht"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"e3ade06278f344ca90fe4fc5781ffc80"), "EddieRuckus"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"83898b2861184900913741ffc46b6e10"), "progwml6"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"0b7509f0245841609ce12772b9a45ac2"), "ohaiiChun"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"aa29ede708174c65b19277a32e772b9c"), "fuj1n"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"d4d119aad410488a87340053577d4a1a"), "Mikeemoo"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"898ed21379b249f98602d1bb03d19ba2"), "boq42"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"9671e3e159184ad0bd473f7f27f57074"), "Toby"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"f3c8d69b077645128434d1b2165909eb"), "dan200"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"cf3e2c7ed70348e0808ef139bf26ff9d"), "ecutruin"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"b1890bac9f4044fa870ba71ce4df05c2"), "nikstick22"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"a9b6837ea916496790c191aef968c96b"), "Mr_okushama"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"0ea8eca3dbf647cc9d1ac64551ca975c"), "sk89q"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"957397819f754c6c9a93621c72f5bf9c"), "ShadwDrgn"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"c501d5507e3c463e8a95256f86d9a47d"), "chicken_bones"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"0f95811ab3b64dbaba034adfec7cf5ab"), "azanor"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"4f3a8d1e33c144e7bce8e683027c7dac"), "Soaryn"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"03020c4cf2f640b1a37c4e2b159b15b7"), "pillbox"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"b476c98e175048bfad5ea21becd0aaeb"), "mDiyo"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"839a930d5b874583b8da0760f9fa0254"), "IceBladeRage"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"4b9a5c51e9324e1ead30637101fb6fae"), "Thunderdark"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"7e6d65ed6fd840a786f8df09791572fc"), "Myrathi"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"b97e12cedbb14c0cafc8132b708a9b88"), "XCompWiz"));
        fallbackPlayerNames.add(new AbstractMap.SimpleEntry<UUID, String>(UUIDTypeAdapter.fromString((String)"e43e9766f90348e1818fd41bb48d80d5"), "FireBall1725"));
        playerItems = new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151010_B), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151036_c)};
        zombieItems = new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151010_B), new ItemStack(Items.field_151036_c)};
        skelItems = new ItemStack[]{new ItemStack((Item)Items.field_151031_f), new ItemStack(Items.field_151010_B), new ItemStack((Item)Items.field_151031_f), new ItemStack((Item)Items.field_151031_f), new ItemStack((Item)Items.field_151031_f), new ItemStack((Item)Items.field_151031_f)};
        horseArmors = new ItemStack[]{new ItemStack(Items.field_151138_bX), new ItemStack(Items.field_151136_bY), new ItemStack(Items.field_151125_bZ)};
        Set<String> entities = EntityList.func_180124_b().stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        if (!entities.removeAll(entityBlacklist)) {
            LogHelper.severe("Nothing got removed!", new Object[0]);
        }
        entStrings = entities.toArray(new String[0]);
        id = -1;
    }
}

