/*
 * Decompiled with CFR 0.152.
 */
package furgl.stupidThings.client;

import com.google.common.collect.Maps;
import furgl.stupidThings.client.gui.GuiCatalog;
import furgl.stupidThings.client.model.ModelAnvilBackpack;
import furgl.stupidThings.client.model.ModelPaperBagHat;
import furgl.stupidThings.client.model.ModelPropellerHat;
import furgl.stupidThings.client.model.ModelUpsideDownGoggles;
import furgl.stupidThings.client.particle.ParticleSmokeCloud;
import furgl.stupidThings.client.renderer.entity.RenderBalloon;
import furgl.stupidThings.client.renderer.entity.RenderBalloonLiquid;
import furgl.stupidThings.client.renderer.entity.RenderBlockBomb;
import furgl.stupidThings.client.renderer.entity.RenderReverseTntPrimed;
import furgl.stupidThings.client.renderer.entity.RenderSmokeBomb;
import furgl.stupidThings.common.CommonProxy;
import furgl.stupidThings.common.StupidThings;
import furgl.stupidThings.common.block.ModBlocks;
import furgl.stupidThings.common.entity.EntityBalloon;
import furgl.stupidThings.common.entity.EntityBalloonLiquid;
import furgl.stupidThings.common.entity.EntityBlockBomb;
import furgl.stupidThings.common.entity.EntityReverseTntPrimed;
import furgl.stupidThings.common.entity.EntitySmokeBomb;
import furgl.stupidThings.common.item.ItemCatalog;
import furgl.stupidThings.common.item.ModItems;
import furgl.stupidThings.common.sound.SoundWorldsSmallestViolin;
import furgl.stupidThings.util.TooltipHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private static final ModelBiped MODEL_ANVIL_BACKPACK = new ModelAnvilBackpack();
    private static final ModelBiped MODEL_PAPER_BAG_HAT = new ModelPaperBagHat();
    private static final ModelBiped MODEL_UPSIDE_DOWN_GOGGLES = new ModelUpsideDownGoggles();
    private HashMap<EntityLivingBase, ModelBiped> modelMap = Maps.newHashMap();
    public static final ArrayList<Item> COLORED_ITEMS = new ArrayList<Item>(Arrays.asList(ModItems.BALLOON, ModItems.BALLOON_DEFLATED, ModItems.BALLOON_WATER, ModItems.BALLOON_LAVA, ModItems.SMOKE_BOMB));

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        StupidThings.util = TooltipHelper.INSTANCE;
        OBJLoader.INSTANCE.addDomain("stupidthings");
        ClientProxy.registerItemObjModels();
        ClientProxy.registerEntityRenders();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ModBlocks.registerRenders();
        ClientProxy.registerItemRenders();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    private static void registerItemObjModels() {
        for (Item item : ModItems.objModelItems) {
            ModItems.registerObjRender(item, 0);
        }
    }

    private static void registerItemRenders() {
        for (Item item : ModItems.allItems) {
            if (ModItems.objModelItems.contains(item)) continue;
            ModItems.registerRender(item, 0);
        }
        for (Item item : COLORED_ITEMS) {
            if (item.getRegistryName() == null) continue;
            for (int i = 1; i < 16; ++i) {
                ModItems.registerRender(item, i);
            }
            Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

                public int func_186726_a(ItemStack stack, int tintIndex) {
                    return tintIndex > 0 ? -1 : MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)stack.func_77960_j())).field_76291_p;
                }
            }, new Item[]{item});
        }
    }

    private static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityReverseTntPrimed.class, RenderReverseTntPrimed::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBalloon.class, RenderBalloon::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBalloonLiquid.class, RenderBalloonLiquid::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySmokeBomb.class, RenderSmokeBomb::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlockBomb.class, RenderBlockBomb::new);
    }

    @Override
    protected void registerEventListeners() {
        super.registerEventListeners();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(ParticleSmokeCloud.TEXTURE);
    }

    @Override
    public Object getArmorModel(Item item, EntityLivingBase entity) {
        if (item == ModItems.ANVIL_BACKPACK) {
            return MODEL_ANVIL_BACKPACK;
        }
        if (item == ModItems.PAPER_BAG_HAT) {
            return MODEL_PAPER_BAG_HAT;
        }
        if (item == ModItems.UPSIDE_DOWN_GOGGLES) {
            return MODEL_UPSIDE_DOWN_GOGGLES;
        }
        if (item == ModItems.PROPELLER_HAT) {
            if (!this.modelMap.containsKey(entity) || !(this.modelMap.get(entity) instanceof ModelPropellerHat)) {
                this.modelMap.put(entity, new ModelPropellerHat());
            }
            return this.modelMap.get(entity);
        }
        return null;
    }

    @Override
    public void spawnParticlesSmokeCloud(World worldIn, int color, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        ParticleSmokeCloud particle = new ParticleSmokeCloud(worldIn, color, x, y, z, motionX, motionY, motionZ, scale);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void addToTab(Item item, CreativeTabs tab, NonNullList<ItemStack> stacks) {
        item.func_77637_a(tab);
        if (item instanceof ItemCatalog) {
            stacks.add(0, (Object)new ItemStack(item));
        } else {
            item.func_150895_a(tab, stacks);
        }
    }

    @Override
    public void openCatalogGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCatalog());
    }

    @Override
    public void playWorldsSmallestViolinSound(EntityPlayer player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundWorldsSmallestViolin(player));
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

