/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui.controls;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import uk.kihira.tails.client.gui.ITooltip;

public class GuiHSBSlider
extends GuiSlider
implements ITooltip {
    private static final ResourceLocation sliderTexture = new ResourceLocation("tails", "texture/gui/controls/slider_hue.png");
    private final HSBSliderType type;
    private final IHSBSliderCallback callback;
    private float hueValue;
    private float briValue;
    private List<String> tooltips;

    public GuiHSBSlider(int id, int xPos, int yPos, int width, int height, IHSBSliderCallback callback, HSBSliderType type) {
        super(id, xPos, yPos, width, height, "", "", 0.0, 1531.0, 0.0, false, false);
        this.type = type;
        this.hueValue = 0.0f;
        this.briValue = 0.0f;
        this.callback = callback;
    }

    public GuiHSBSlider(int id, int xPos, int yPos, int width, int height, IHSBSliderCallback callback, HSBSliderType type, String ... tooltips) {
        this(id, xPos, yPos, width, height, callback, type);
        this.tooltips = Arrays.asList(tooltips);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)GuiButton.field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)46, (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            mc.field_71446_o.func_110577_a(sliderTexture);
            if (this.type == HSBSliderType.SATURATION) {
                Color hueColour = Color.getHSBColor(this.hueValue, 1.0f, 1.0f);
                float red = (float)hueColour.getRed() / 255.0f;
                float green = (float)hueColour.getGreen() / 255.0f;
                float blue = (float)hueColour.getBlue() / 255.0f;
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
                this.drawTexturedModalRectScaled(this.field_146128_h + 1, this.field_146129_i + 1, 0, 176, 256, 20, this.field_146120_f - 2, this.field_146121_g - 2);
            }
            int srcY = 236;
            if (this.type == HSBSliderType.BRIGHTNESS) {
                srcY -= 20;
            }
            if (this.type == HSBSliderType.SATURATION) {
                srcY -= 40;
            }
            if (this.type == HSBSliderType.SATURATION) {
                Color hueColour = Color.getHSBColor(0.0f, 0.0f, this.briValue);
                float red = (float)hueColour.getRed() / 255.0f;
                float green = (float)hueColour.getGreen() / 255.0f;
                float blue = (float)hueColour.getBlue() / 255.0f;
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
                this.drawTexturedModalRectScaled(this.field_146128_h + 1, this.field_146129_i + 1, 0, srcY, 231, 20, this.field_146120_f - 2, this.field_146121_g - 2);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRectScaled(this.field_146128_h + 1, this.field_146129_i + 1, 0, srcY, 256, 20, this.field_146120_f - 2, this.field_146121_g - 2);
            }
            this.func_146119_b(mc, mouseX, mouseY);
        }
    }

    protected void func_146119_b(Minecraft mc, int par2, int par3) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
                if (this.callback != null) {
                    this.callback.onValueChangeHSBSlider(this, this.sliderValue);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(sliderTexture);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 3) - 2.0), this.field_146129_i, 0, 0, 7, 4);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 3) - 2.0), this.field_146129_i + this.field_146121_g - 4, 7, 0, 7, 4);
        }
    }

    public HSBSliderType getType() {
        return this.type;
    }

    public double getValue() {
        return this.sliderValue;
    }

    public void setValue(double value) {
        this.sliderValue = value;
        this.updateSlider();
    }

    public void setValueWithCallback(double value) {
        this.sliderValue = value;
        this.updateSlider();
        if (this.callback != null) {
            this.callback.onValueChangeHSBSlider(this, this.sliderValue);
        }
    }

    public void setHue(float value) {
        this.hueValue = value;
    }

    public void setBrightness(float value) {
        this.briValue = value;
    }

    void drawTexturedModalRectScaled(int x, int y, int u, int v, int srcWidth, int srcHeight, int tarWidth, int tarHeight) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0), (double)(y + tarHeight), (double)this.field_73735_i).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + srcHeight) * f1)).func_181675_d();
        renderer.func_181662_b((double)(x + tarWidth), (double)(y + tarHeight), (double)this.field_73735_i).func_187315_a((double)((float)(u + srcWidth) * f), (double)((float)(v + srcHeight) * f1)).func_181675_d();
        renderer.func_181662_b((double)(x + tarWidth), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(u + srcWidth) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY, float mouseIdleTime) {
        return this.tooltips;
    }

    public static interface IHSBSliderCallback {
        public void onValueChangeHSBSlider(GuiHSBSlider var1, double var2);
    }

    public static enum HSBSliderType {
        HUE,
        SATURATION,
        BRIGHTNESS;

    }
}

