/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.proxy;

import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uk.kihira.tails.client.ClientEventHandler;
import uk.kihira.tails.client.FakeEntity;
import uk.kihira.tails.client.model.ModelRendererWrapper;
import uk.kihira.tails.client.render.FakeEntityRenderHelper;
import uk.kihira.tails.client.render.LayerPart;
import uk.kihira.tails.client.render.PlayerRenderHelper;
import uk.kihira.tails.client.render.RenderPart;
import uk.kihira.tails.client.render.RenderingHandler;
import uk.kihira.tails.common.LibraryManager;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;
import uk.kihira.tails.common.network.LibraryEntriesMessage;
import uk.kihira.tails.common.network.LibraryRequestMessage;
import uk.kihira.tails.common.network.PlayerDataMapMessage;
import uk.kihira.tails.common.network.PlayerDataMessage;
import uk.kihira.tails.common.network.ServerCapabilitiesMessage;
import uk.kihira.tails.proxy.CommonProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        this.registerMessages();
        this.registerHandlers();
        this.libraryManager = new LibraryManager.ClientLibraryManager();
        RenderPart.registerRenderHelper(EntityPlayer.class, new PlayerRenderHelper());
        RenderPart.registerRenderHelper(FakeEntity.class, new FakeEntityRenderHelper());
    }

    @Override
    public void addPartsData(UUID uuid, PartsData partsData) {
        if (this.hasPartsData(uuid)) {
            ((PartsData)this.partsData.get(uuid)).clearTextures();
        }
        super.addPartsData(uuid, partsData);
    }

    @Override
    public void removePartsData(UUID uuid) {
        if (this.hasPartsData(uuid)) {
            ((PartsData)this.partsData.get(uuid)).clearTextures();
        }
        super.removePartsData(uuid);
    }

    @Override
    public void clearAllPartsData() {
        for (PartsData partInfo : this.partsData.values()) {
            partInfo.clearTextures();
        }
        super.clearAllPartsData();
    }

    @Override
    public void registerMessages() {
        Tails.networkWrapper.registerMessage(PlayerDataMessage.Handler.class, PlayerDataMessage.class, 0, Side.CLIENT);
        Tails.networkWrapper.registerMessage(PlayerDataMapMessage.Handler.class, PlayerDataMapMessage.class, 1, Side.CLIENT);
        Tails.networkWrapper.registerMessage(LibraryEntriesMessage.Handler.class, LibraryEntriesMessage.class, 2, Side.CLIENT);
        Tails.networkWrapper.registerMessage(LibraryRequestMessage.Handler.class, LibraryRequestMessage.class, 3, Side.CLIENT);
        Tails.networkWrapper.registerMessage(ServerCapabilitiesMessage.Handler.class, ServerCapabilitiesMessage.class, 4, Side.CLIENT);
        super.registerMessages();
    }

    @Override
    public void registerHandlers() {
        ClientEventHandler eventHandler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    @Override
    public void registerRenderers() {
        boolean legacyRenderer = Tails.configuration.getBoolean("client", "ForceLegacyRendering", false, "Forces the legacy renderer which may have better compatibility with other mods");
        if (legacyRenderer) {
            Tails.logger.info("Legacy Renderer has been forced enabled");
        } else if (Loader.isModLoaded((String)"SmartMoving")) {
            Tails.logger.info("Legacy Renderer enabled automatically for mod compatibility");
            legacyRenderer = true;
        }
        if (legacyRenderer) {
            MinecraftForge.EVENT_BUS.register((Object)new RenderingHandler());
            Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
            ModelPlayer model = ((RenderPlayer)skinMap.get("default")).func_177087_b();
            model.field_78115_e.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.TAIL));
            model.field_78115_e.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.WINGS));
            model.field_78116_c.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.EARS));
            model.field_78116_c.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.MUZZLE));
            model = ((RenderPlayer)skinMap.get("slim")).func_177087_b();
            model.field_78115_e.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.TAIL));
            model.field_78115_e.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.WINGS));
            model.field_78116_c.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.EARS));
            model.field_78116_c.func_78792_a((ModelRenderer)new ModelRendererWrapper((ModelBase)model, PartsData.PartType.MUZZLE));
        } else {
            Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
            RenderPlayer renderPlayer = (RenderPlayer)skinMap.get("default");
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78115_e, PartsData.PartType.TAIL));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78115_e, PartsData.PartType.WINGS));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78116_c, PartsData.PartType.EARS));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78116_c, PartsData.PartType.MUZZLE));
            renderPlayer = (RenderPlayer)skinMap.get("slim");
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78115_e, PartsData.PartType.TAIL));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78115_e, PartsData.PartType.WINGS));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78116_c, PartsData.PartType.EARS));
            renderPlayer.func_177094_a((LayerRenderer)new LayerPart(renderPlayer.func_177087_b().field_78116_c, PartsData.PartType.MUZZLE));
        }
    }
}

