/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders.util;

import com.anthonyhilyard.itemborders.util.TextColor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class ItemColor {
    public static Integer findFirstColorCode(String rawTitle) {
        for (int i = 0; i < rawTitle.length(); i += 2) {
            if (rawTitle.charAt(i) == '\u00a7') {
                try {
                    String format = String.valueOf(rawTitle.charAt(i)) + String.valueOf(rawTitle.charAt(i + 1));
                    Integer color = TextColor.getColorFromFormatCode(format);
                    if (color == null) continue;
                    return color;
                }
                catch (StringIndexOutOfBoundsException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static Integer getColorForItem(ItemStack item, Integer defaultColor) {
        Integer result = null;
        Integer rarityColor = null;
        if (item == null) {
            return defaultColor;
        }
        if (item.func_151000_E() != null && item.func_151000_E().func_150256_b() != null && item.func_151000_E().func_150256_b().func_150215_a() != null) {
            result = rarityColor = TextColor.getColorFromFormatCode(item.func_151000_E().func_150256_b().func_150215_a().toString());
        }
        if (item.func_77942_o() && item.func_77978_p().func_150297_b("display", 10) && item.func_77978_p().func_74775_l("display").func_150297_b("color", 3)) {
            result = item.func_77978_p().func_74775_l("display").func_74762_e("color");
        }
        if (result == null || result == rarityColor) {
            Integer colorCode;
            Minecraft mc = Minecraft.func_71410_x();
            List lines = item.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
            if (!lines.isEmpty() && (colorCode = ItemColor.findFirstColorCode((String)lines.get(0))) != null) {
                result = colorCode;
            }
        }
        if (result == null) {
            result = defaultColor;
        }
        return result;
    }
}

