/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AdvancementTriggers
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("inventorypets", "");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners consumeitemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (consumeitemtrigger$listeners == null) {
            consumeitemtrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, consumeitemtrigger$listeners);
        }
        consumeitemtrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners consumeitemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (consumeitemtrigger$listeners != null) {
            consumeitemtrigger$listeners.remove(listener);
            if (consumeitemtrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ItemStack item = null;
        EntityEntry entity = null;
        if (json.has("itemstack")) {
            ResourceLocation entityloc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"entity"));
            item = AdvancementTriggers.getItemStack(JsonUtils.func_152754_s((JsonObject)json, (String)"itemstack"));
            if (item.func_190926_b()) {
                throw new JsonSyntaxException("Item cannot be air '" + JsonUtils.func_152754_s((JsonObject)json, (String)"item").toString() + "'");
            }
            if (!ForgeRegistries.ENTITIES.containsKey(entityloc)) {
                throw new JsonSyntaxException("Unknown entity '" + entityloc + "'");
            }
            entity = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityloc);
        }
        return new Instance(item, entity);
    }

    public void trigger(EntityPlayerMP player, ItemStack item, EntityEntry entry) {
        Listeners enterblocktrigger$listeners = this.listeners.get(player.func_192039_O());
        if (enterblocktrigger$listeners != null) {
            enterblocktrigger$listeners.trigger(item, entry);
        }
    }

    public static ItemStack getItemStack(JsonObject json) {
        String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.func_77614_k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack(item, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack item, EntityEntry entry) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(item, entry)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemStack item;
        private final EntityEntry entity;

        public Instance(@Nullable ItemStack item, @Nullable EntityEntry entity) {
            super(ID);
            this.item = item;
            this.entity = entity;
        }

        public boolean test(ItemStack item, EntityEntry entry) {
            if (item != null && this.item != null) {
                ItemStack s1 = this.item.func_77946_l();
                ItemStack s2 = item.func_77946_l();
                s1.func_190920_e(1);
                s2.func_190920_e(1);
                boolean equal = ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
                if (this.entity != null && equal && entry == this.entity) {
                    return true;
                }
            }
            return false;
        }
    }
}

