/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app;

import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Window;
import com.mrcrayfish.device.core.Wrappable;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.util.GLHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public abstract class Application
extends Wrappable {
    protected final AppInfo info = null;
    private BlockPos laptopPositon;
    private int width;
    private int height;
    private final Layout defaultLayout = new Layout();
    private Layout currentLayout;
    private boolean needsDataUpdate = false;
    private boolean pendingLayoutUpdate = false;

    public AppInfo getInfo() {
        return this.info;
    }

    protected final void addComponent(Component c) {
        if (c != null) {
            this.defaultLayout.addComponent(c);
        }
    }

    public final void setCurrentLayout(Layout layout) {
        if (this.currentLayout != null) {
            this.currentLayout.handleUnload();
        }
        this.currentLayout = layout;
        this.width = layout.width;
        this.height = layout.height;
        this.pendingLayoutUpdate = true;
        this.currentLayout.handleLoad();
    }

    public final Layout getCurrentLayout() {
        return this.currentLayout;
    }

    public final void restoreDefaultLayout() {
        this.setCurrentLayout(this.defaultLayout);
    }

    @Override
    public abstract void init(@Nullable NBTTagCompound var1);

    @Override
    public void onTick() {
        this.currentLayout.handleTick();
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        GL11.glEnable((int)3089);
        GLHelper.pushScissor(x, y, this.width, this.height);
        this.currentLayout.render(laptop, mc, x, y, mouseX, mouseY, active, partialTicks);
        GLHelper.popScissor();
        if (!GLHelper.isScissorStackEmpty()) {
            MrCrayfishDeviceMod.getLogger().error("ERROR: A component is not popping it's scissor!");
        }
        GLHelper.clearScissorStack();
        GL11.glDisable((int)3089);
        this.currentLayout.renderOverlay(laptop, mc, mouseX, mouseY, active);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        this.currentLayout.handleMouseScroll(mouseX, mouseY, direction);
    }

    @Override
    public void handleKeyTyped(char character, int code) {
        this.currentLayout.handleKeyTyped(character, code);
    }

    @Override
    public void handleKeyReleased(char character, int code) {
        this.currentLayout.handleKeyReleased(character, code);
    }

    @Override
    public final void updateComponents(int x, int y) {
        this.currentLayout.updateComponents(x, y);
    }

    @Override
    public void onClose() {
        this.defaultLayout.clear();
        this.currentLayout = null;
    }

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1);

    protected final void setDefaultWidth(int width) {
        if (width < 20) {
            throw new IllegalArgumentException("Width must be larger than 20");
        }
        this.defaultLayout.width = width;
    }

    protected final void setDefaultHeight(int height) {
        if (height < 20) {
            throw new IllegalArgumentException("Height must be larger than 20");
        }
        this.defaultLayout.height = height;
    }

    protected void markDirty() {
        this.needsDataUpdate = true;
    }

    public final boolean isDirty() {
        return this.needsDataUpdate;
    }

    public final void clean() {
        this.needsDataUpdate = false;
    }

    @Override
    public final void markForLayoutUpdate() {
        this.pendingLayoutUpdate = true;
    }

    @Override
    public final boolean isPendingLayoutUpdate() {
        return this.pendingLayoutUpdate;
    }

    @Override
    public final void clearPendingLayout() {
        this.pendingLayoutUpdate = false;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public String getWindowTitle() {
        if (this.currentLayout.hasTitle()) {
            return this.currentLayout.getTitle();
        }
        return this.info.getName();
    }

    public String getApplicationFolderPath() {
        return "/Application Data/" + this.info.getFormattedId();
    }

    @Nullable
    public Window<Dialog> getActiveDialog() {
        Window<Dialog> dialogWindow = this.getWindow().getDialogWindow();
        if (dialogWindow != null) {
            while (true) {
                if (dialogWindow.getDialogWindow() == null) {
                    return dialogWindow;
                }
                dialogWindow = dialogWindow.getDialogWindow();
            }
        }
        return dialogWindow;
    }

    public boolean handleFile(File file) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application app = (Application)obj;
        return app.info.getFormattedId().equals(this.info.getFormattedId());
    }
}

