/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app.component;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.listener.ClickListener;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import scala.actors.threadpool.Arrays;

public class Inventory
extends Component {
    protected static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    protected int selectedColor = new Color(1.0f, 1.0f, 0.0f, 0.15f).getRGB();
    protected int hoverColor = new Color(1.0f, 1.0f, 1.0f, 0.15f).getRGB();
    protected int selected = -1;
    protected ClickListener clickListener = null;

    public Inventory(int left, int top) {
        super(left, top);
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
            RenderUtil.drawRectWithTexture(this.xPosition, this.yPosition, 7.0f, 139.0f, 162, 54, 162.0f, 54.0f);
            InventoryPlayer inventory = mc.field_71439_g.field_71071_by;
            for (int i = 9; i < inventory.func_70302_i_() - 4; ++i) {
                ItemStack stack;
                int offsetX = i % 9 * 18;
                int offsetY = i / 9 * 18 - 18;
                if (this.selected == i) {
                    Gui.func_73734_a((int)(this.xPosition + offsetX), (int)(this.yPosition + offsetY), (int)(this.xPosition + offsetX + 18), (int)(this.yPosition + offsetY + 18), (int)this.selectedColor);
                }
                if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + offsetX, this.yPosition + offsetY, this.xPosition + offsetX + 17, this.yPosition + offsetY + 17)) {
                    Gui.func_73734_a((int)(this.xPosition + offsetX), (int)(this.yPosition + offsetY), (int)(this.xPosition + offsetX + 18), (int)(this.yPosition + offsetY + 18), (int)this.hoverColor);
                }
                if ((stack = inventory.func_70301_a(i)).func_190926_b()) continue;
                RenderUtil.renderItem(this.xPosition + offsetX + 1, this.yPosition + offsetY + 1, stack, true);
            }
        }
    }

    @Override
    public void renderOverlay(Laptop laptop, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        if (this.visible) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    int x = this.xPosition + j * 18 - 1;
                    int y = this.yPosition + i * 18 - 1;
                    if (!GuiHelper.isMouseInside(mouseX, mouseY, x, y, x + 18, y + 18)) continue;
                    ItemStack stack = mc.field_71439_g.field_71071_by.func_70301_a(i * 9 + j + 9);
                    if (!stack.func_190926_b()) {
                        laptop.func_146283_a(Arrays.asList((Object[])new String[]{stack.func_82833_r()}), mouseX, mouseY);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int x = this.xPosition + j * 18 - 1;
                int y = this.yPosition + i * 18 - 1;
                if (!GuiHelper.isMouseInside(mouseX, mouseY, x, y, x + 18, y + 18)) continue;
                this.selected = i * 9 + j + 9;
                if (this.clickListener != null) {
                    this.clickListener.onClick(mouseX, mouseY, mouseButton);
                }
                return;
            }
        }
    }

    public int getSelectedSlotIndex() {
        return this.selected;
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setSelectedColor(int selectedColor) {
        this.selectedColor = selectedColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }
}

