/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.network.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.network.task.MessageResponse;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequest
implements IMessage,
IMessageHandler<MessageRequest, IMessage> {
    private int id;
    private Task request;
    private NBTTagCompound nbt;

    public MessageRequest() {
    }

    public MessageRequest(int id, Task request) {
        this.id = id;
        this.request = request;
    }

    public int getId() {
        return this.id;
    }

    public IMessage onMessage(MessageRequest message, MessageContext ctx) {
        message.request.processRequest(message.nbt, ctx.getServerHandler().field_147369_b.field_70170_p, (EntityPlayer)ctx.getServerHandler().field_147369_b);
        return new MessageResponse(message.id, message.request);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.request = TaskManager.getTask(name);
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.request.getName());
        NBTTagCompound nbt = new NBTTagCompound();
        this.request.prepareRequest(nbt);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }
}

