/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Inventory;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.NumberSelector;
import com.mrcrayfish.device.api.app.listener.ClickListener;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.BankUtil;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.programs.auction.AuctionManager;
import com.mrcrayfish.device.programs.auction.object.AuctionItem;
import com.mrcrayfish.device.programs.auction.task.TaskAddAuction;
import com.mrcrayfish.device.programs.auction.task.TaskBuyItem;
import com.mrcrayfish.device.programs.auction.task.TaskGetAuctions;
import com.mrcrayfish.device.util.TimeUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ApplicationMineBay
extends Application {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    private static final ResourceLocation MINEBAY_ASSESTS = new ResourceLocation("cdm:textures/gui/minebay.png");
    private static final ItemStack EMERALD = new ItemStack(Items.field_151166_bC);
    private String[] categories = new String[]{"Building", "Combat", "Tools", "Food", "Materials", "Redstone", "Alchemy", "Rare", "Misc"};
    private Layout layoutMyAuctions;
    private ItemList<AuctionItem> items;
    private Layout layoutSelectItem;
    private Inventory inventory;
    private Button buttonAddCancel;
    private Button buttonAddNext;
    private Layout layoutAmountAndPrice;
    private Label labelAmount;
    private NumberSelector selectorAmount;
    private Label labelPrice;
    private NumberSelector selectorPrice;
    private Button buttonAmountAndPriceBack;
    private Button buttonAmountAndPriceCancel;
    private Button buttonAmountAndPriceNext;
    private Layout layoutDuration;
    private Label labelHours;
    private Label labelMinutes;
    private Label labelSeconds;
    private NumberSelector selectorHours;
    private NumberSelector selectorMinutes;
    private NumberSelector selectorSeconds;
    private Button buttonDurationBack;
    private Button buttonDurationCancel;
    private Button buttonDurationAdd;

    @Override
    public void onTick() {
        super.onTick();
        AuctionManager.INSTANCE.tick();
    }

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.getCurrentLayout().setBackground(new Layout.Background(){

            @Override
            public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 25), (int)Color.GRAY.getRGB());
                Gui.func_73734_a((int)x, (int)(y + 24), (int)(x + width), (int)(y + 25), (int)Color.DARK_GRAY.getRGB());
                Gui.func_73734_a((int)x, (int)(y + 25), (int)(x + 95), (int)(y + height), (int)Color.LIGHT_GRAY.getRGB());
                Gui.func_73734_a((int)(x + 94), (int)(y + 25), (int)(x + 95), (int)(y + height), (int)Color.GRAY.getRGB());
                mc.func_110434_K().func_110577_a(MINEBAY_ASSESTS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.drawRectWithTexture(x + 5, y + 6, 0.0f, 0.0f, 61, 11, 61.0f, 12.0f);
            }
        });
        Button btnAddItem = new Button(70, 5, "Add Item");
        btnAddItem.setSize(60, 15);
        btnAddItem.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        super.addComponent(btnAddItem);
        Button btnViewItem = new Button(135, 5, "Your Auctions");
        btnViewItem.setSize(80, 15);
        btnViewItem.setClickListener((mouseX, mouseY, mouseButton) -> {
            TaskGetAuctions task = new TaskGetAuctions(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            task.setCallback((nbt, success) -> {
                this.items.removeAll();
                for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                    this.items.addItem(item);
                }
            });
            TaskManager.sendTask(task);
        });
        super.addComponent(btnViewItem);
        Label labelBalance = new Label("Balance", 295, 3);
        labelBalance.setAlignment(1);
        super.addComponent(labelBalance);
        Label labelMoney = new Label("$0", 295, 13);
        labelMoney.setAlignment(1);
        labelMoney.setScale(1.0);
        labelMoney.setShadow(false);
        super.addComponent(labelMoney);
        Label labelCategories = new Label("Categories", 5, 29);
        labelCategories.setShadow(false);
        super.addComponent(labelCategories);
        ItemList<String> categories = new ItemList<String>(5, 40, 70, 7);
        for (String category : this.categories) {
            categories.addItem(category);
        }
        super.addComponent(categories);
        Label labelItems = new Label("Items", 100, 29);
        labelItems.setShadow(false);
        super.addComponent(labelItems);
        this.items = new ItemList(100, 40, 180, 4);
        this.items.setListItemRenderer(new ListItemRenderer<AuctionItem>(20){

            @Override
            public void render(AuctionItem e, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                if (selected) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.DARK_GRAY.getRGB());
                } else {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)Color.GRAY.getRGB());
                }
                RenderUtil.renderItem(x + 2, y + 2, e.getStack(), true);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(x + 24), (float)(y + 4), (float)0.0f);
                GlStateManager.func_179139_a((double)0.666, (double)0.666, (double)0.0);
                mc.field_71466_p.func_175065_a(e.getStack().func_82833_r(), 0.0f, 0.0f, Color.WHITE.getRGB(), false);
                mc.field_71466_p.func_175065_a(TimeUtil.getTotalRealTime(e.getTimeLeft()), 0.0f, 11.0f, Color.LIGHT_GRAY.getRGB(), false);
                GlStateManager.func_179121_F();
                String price = "$" + e.getPrice();
                mc.field_71466_p.func_78276_b(price, x - mc.field_71466_p.func_78256_a(price) + width - 5, y + 6, Color.YELLOW.getRGB());
            }
        });
        super.addComponent(this.items);
        Button btnBuy = new Button(100, 127, "Buy");
        btnBuy.setSize(50, 15);
        btnBuy.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setPositiveText("Buy");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                int index = this.items.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                AuctionItem item = this.items.getItem(index);
                if (item != null) {
                    TaskBuyItem task = new TaskBuyItem(item.getId());
                    task.setCallback((nbt, success) -> {
                        if (success) {
                            this.items.removeItem(index);
                        }
                    });
                    TaskManager.sendTask(task);
                }
            });
            dialog.setNegativeText("Cancel");
            dialog.setNegativeListener((mouseX1, mouseY1, mouseButton1) -> dialog.close());
            this.openDialog(dialog);
        });
        super.addComponent(btnBuy);
        this.layoutSelectItem = new Layout(172, 87);
        this.layoutSelectItem.setTitle("Add Item");
        this.layoutSelectItem.setBackground(new Layout.Background(){

            @Override
            public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
                Gui.func_73734_a((int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
                mc.field_71466_p.func_175065_a("Select an Item...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB(), true);
            }
        });
        this.inventory = new Inventory(5, 28);
        this.inventory.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.inventory.getSelectedSlotIndex() != -1) {
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(this.inventory.getSelectedSlotIndex());
                if (!stack.func_190926_b()) {
                    this.buttonAddNext.setEnabled(true);
                    this.selectorAmount.setMax(stack.func_190916_E());
                    this.selectorAmount.setNumber(stack.func_190916_E());
                } else {
                    this.buttonAddNext.setEnabled(false);
                }
            }
        });
        this.layoutSelectItem.addComponent(this.inventory);
        this.buttonAddCancel = new Button(138, 4, MINEBAY_ASSESTS, 0, 12, 8, 8);
        this.buttonAddCancel.setToolTip("Cancel", "Go back to main page");
        this.buttonAddCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutSelectItem.addComponent(this.buttonAddCancel);
        this.buttonAddNext = new Button(154, 4, MINEBAY_ASSESTS, 16, 12, 8, 8);
        this.buttonAddNext.setToolTip("Next Page", "Set price and amount");
        this.buttonAddNext.setEnabled(false);
        this.buttonAddNext.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.selectorAmount.updateButtons();
            this.selectorPrice.updateButtons();
            this.setCurrentLayout(this.layoutAmountAndPrice);
        });
        this.layoutSelectItem.addComponent(this.buttonAddNext);
        this.layoutAmountAndPrice = new Layout(172, 87);
        this.layoutAmountAndPrice.setTitle("Add Item");
        this.layoutAmountAndPrice.setBackground(new Layout.Background(){

            @Override
            public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                ItemStack stack;
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
                Gui.func_73734_a((int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
                mc.field_71466_p.func_175065_a("Set amount and price...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB(), true);
                int offsetX = 14;
                int offsetY = 40;
                Gui.func_73734_a((int)(x + offsetX), (int)(y + offsetY), (int)(x + offsetX + 38), (int)(y + offsetY + 38), (int)Color.BLACK.getRGB());
                Gui.func_73734_a((int)(x + offsetX + 1), (int)(y + offsetY + 1), (int)(x + offsetX + 37), (int)(y + offsetY + 37), (int)Color.DARK_GRAY.getRGB());
                offsetX = 90;
                Gui.func_73734_a((int)(x + offsetX), (int)(y + offsetY), (int)(x + offsetX + 38), (int)(y + offsetY + 38), (int)Color.BLACK.getRGB());
                Gui.func_73734_a((int)(x + offsetX + 1), (int)(y + offsetY + 1), (int)(x + offsetX + 37), (int)(y + offsetY + 37), (int)Color.DARK_GRAY.getRGB());
                if (ApplicationMineBay.this.inventory.getSelectedSlotIndex() != -1 && !(stack = mc.field_71439_g.field_71071_by.func_70301_a(ApplicationMineBay.this.inventory.getSelectedSlotIndex())).func_190926_b()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(x + 17), (float)(y + 43), (float)0.0f);
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)0.0f);
                    RenderUtil.renderItem(0, 0, stack, false);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(x + 92), (float)(y + 43), (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)0.0f);
                RenderUtil.renderItem(0, 0, EMERALD, false);
                GlStateManager.func_179121_F();
            }
        });
        this.buttonAmountAndPriceBack = new Button(122, 4, MINEBAY_ASSESTS, 8, 12, 8, 8);
        this.buttonAmountAndPriceBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceBack);
        this.buttonAmountAndPriceCancel = new Button(138, 4, MINEBAY_ASSESTS, 0, 12, 8, 8);
        this.buttonAmountAndPriceCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceCancel);
        this.buttonAmountAndPriceNext = new Button(154, 4, MINEBAY_ASSESTS, 16, 12, 8, 8);
        this.buttonAmountAndPriceNext.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutDuration));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceNext);
        this.labelAmount = new Label("Amount", 16, 30);
        this.layoutAmountAndPrice.addComponent(this.labelAmount);
        this.selectorAmount = new NumberSelector(55, 42, 18);
        this.selectorAmount.setMax(64);
        this.layoutAmountAndPrice.addComponent(this.selectorAmount);
        this.labelPrice = new Label("Price", 96, 30);
        this.layoutAmountAndPrice.addComponent(this.labelPrice);
        this.selectorPrice = new NumberSelector(131, 42, 24);
        this.selectorPrice.setMax(999);
        this.layoutAmountAndPrice.addComponent(this.selectorPrice);
        this.layoutDuration = new Layout(172, 87);
        this.layoutDuration.setTitle("Add Item");
        this.layoutDuration.setBackground(new Layout.Background(){

            @Override
            public void render(Gui gui, Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 22), (int)Color.LIGHT_GRAY.getRGB());
                Gui.func_73734_a((int)x, (int)(y + 22), (int)(x + width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
                mc.field_71466_p.func_175065_a("Set duration...", (float)(x + 5), (float)(y + 7), Color.WHITE.getRGB(), true);
            }
        });
        this.buttonDurationBack = new Button(122, 4, MINEBAY_ASSESTS, 8, 12, 8, 8);
        this.buttonDurationBack.setClickListener(new ClickListener(){

            @Override
            public void onClick(int mouseX, int mouseY, int mouseButton) {
                ApplicationMineBay.this.setCurrentLayout(ApplicationMineBay.this.layoutAmountAndPrice);
            }
        });
        this.layoutDuration.addComponent(this.buttonDurationBack);
        this.buttonDurationCancel = new Button(138, 4, MINEBAY_ASSESTS, 0, 12, 8, 8);
        this.buttonDurationCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutDuration.addComponent(this.buttonDurationCancel);
        this.buttonDurationAdd = new Button(154, 4, MINEBAY_ASSESTS, 24, 12, 8, 8);
        this.buttonDurationAdd.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setMessageText("Are you sure you want to auction this item?");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                int ticks = (int)TimeUtil.getRealTimeToTicks(this.selectorHours.getNumber(), this.selectorMinutes.getNumber(), this.selectorSeconds.getNumber());
                TaskAddAuction task = new TaskAddAuction(this.inventory.getSelectedSlotIndex(), this.selectorAmount.getNumber(), this.selectorPrice.getNumber(), ticks);
                task.setCallback((nbt, success) -> {
                    if (success) {
                        List<AuctionItem> auctionItems = AuctionManager.INSTANCE.getItems();
                        this.items.addItem(auctionItems.get(auctionItems.size() - 1));
                    }
                });
                TaskManager.sendTask(task);
                dialog.close();
                this.restoreDefaultLayout();
            });
            this.openDialog(dialog);
        });
        this.layoutDuration.addComponent(this.buttonDurationAdd);
        this.labelHours = new Label("Hrs", 45, 30);
        this.layoutDuration.addComponent(this.labelHours);
        this.labelMinutes = new Label("Mins", 76, 30);
        this.layoutDuration.addComponent(this.labelMinutes);
        this.labelSeconds = new Label("Secs", 105, 30);
        this.layoutDuration.addComponent(this.labelSeconds);
        DecimalFormat format = new DecimalFormat("00");
        this.selectorHours = new NumberSelector(45, 42, 20);
        this.selectorHours.setMax(23);
        this.selectorHours.setMin(0);
        this.selectorHours.setFormat(format);
        this.layoutDuration.addComponent(this.selectorHours);
        this.selectorMinutes = new NumberSelector(76, 42, 20);
        this.selectorMinutes.setMax(59);
        this.selectorMinutes.setMin(0);
        this.selectorMinutes.setFormat(format);
        this.layoutDuration.addComponent(this.selectorMinutes);
        this.selectorSeconds = new NumberSelector(107, 42, 20);
        this.selectorSeconds.setMax(59);
        this.selectorSeconds.setMin(1);
        this.selectorSeconds.setFormat(format);
        this.layoutDuration.addComponent(this.selectorSeconds);
        BankUtil.getBalance((nbt, success) -> {
            if (success) {
                labelMoney.setText("$" + nbt.func_74762_e("balance"));
            }
        });
        TaskGetAuctions task = new TaskGetAuctions();
        task.setCallback((nbt, success) -> {
            this.items.removeAll();
            for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                this.items.addItem(item);
            }
        });
        TaskManager.sendTask(task);
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }
}

