/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.programs.auction.AuctionManager;
import com.mrcrayfish.device.programs.auction.object.AuctionItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TaskGetAuctions
extends Task {
    private UUID seller;

    public TaskGetAuctions() {
        super("minebay_get_auctions");
    }

    public TaskGetAuctions(UUID seller) {
        this();
        this.seller = seller;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        if (this.seller != null) {
            nbt.func_74778_a("seller", this.seller.toString());
        }
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        if (nbt.func_74764_b("seller")) {
            this.seller = UUID.fromString(nbt.func_74779_i("seller"));
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.seller != null) {
            List<AuctionItem> items = AuctionManager.INSTANCE.getItemsForSeller(this.seller);
            NBTTagList tagList = new NBTTagList();
            items.forEach(i -> {
                NBTTagCompound itemTag = new NBTTagCompound();
                i.writeToNBT(itemTag);
                tagList.func_74742_a((NBTBase)itemTag);
            });
            nbt.func_74782_a("auctionItems", (NBTBase)tagList);
        } else {
            AuctionManager.INSTANCE.writeToNBT(nbt);
        }
        this.setSuccessful();
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
        AuctionManager.INSTANCE.readFromNBT(nbt);
    }
}

