/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.component;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.ScrollableLayout;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.utils.OnlineRequest;
import com.mrcrayfish.device.programs.gitweb.module.AnvilModule;
import com.mrcrayfish.device.programs.gitweb.module.BannerModule;
import com.mrcrayfish.device.programs.gitweb.module.BrewingModule;
import com.mrcrayfish.device.programs.gitweb.module.CraftingModule;
import com.mrcrayfish.device.programs.gitweb.module.DividerModule;
import com.mrcrayfish.device.programs.gitweb.module.DownloadModule;
import com.mrcrayfish.device.programs.gitweb.module.FooterModule;
import com.mrcrayfish.device.programs.gitweb.module.FurnaceModule;
import com.mrcrayfish.device.programs.gitweb.module.HeaderModule;
import com.mrcrayfish.device.programs.gitweb.module.Module;
import com.mrcrayfish.device.programs.gitweb.module.ModuleEntry;
import com.mrcrayfish.device.programs.gitweb.module.NavigationModule;
import com.mrcrayfish.device.programs.gitweb.module.ParagraphModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;

public class GitWebFrame
extends Component {
    public static final Pattern PATTERN_LINK = Pattern.compile("(?<domain>[a-zA-Z\\-]+)\\.(?<extension>[a-zA-Z]+)(?<directory>(/[a-zA-Z\\-]+)*)(/)?");
    private static final Map<String, Module> MODULES = new HashMap<String, Module>();
    private Application app;
    private ScrollableLayout layout;
    private int width;
    private int height;
    private boolean allowRemoteUrls = false;
    private boolean initialized = false;
    private String currentWebsite;
    private String pendingWebsite;
    private String pendingUrl;
    private Callback<String> loadingCallback;
    private Callback<String> loadedCallback;

    public GitWebFrame(Application app, int left, int top, int width, int height) {
        super(left, top);
        this.app = app;
        this.width = width;
        this.height = height;
        this.layout = new ScrollableLayout(left, top, width, height, height);
        this.layout.setScrollSpeed(8);
    }

    @Override
    protected void init(Layout layout) {
        layout.addComponent(this.layout);
    }

    @Override
    protected void handleLoad() {
        this.initialized = true;
        if (this.pendingUrl != null) {
            this.setUrl(this.pendingUrl);
            this.pendingUrl = null;
        } else if (this.pendingWebsite != null) {
            this.setWebsite(this.pendingWebsite);
            this.pendingWebsite = null;
        }
    }

    @Override
    protected void handleUnload() {
        this.initialized = false;
    }

    @Override
    protected void handleTick() {
        if (this.pendingWebsite != null) {
            this.setWebsite(this.pendingWebsite);
            this.pendingWebsite = null;
        } else if (this.pendingUrl != null) {
            this.setUrl(this.pendingUrl);
            this.pendingUrl = null;
        }
    }

    public void setAllowRemoteUrls(boolean allowRemoteUrls) {
        this.allowRemoteUrls = allowRemoteUrls;
    }

    public void scrollToTop() {
        this.layout.resetScroll();
    }

    public void loadRaw(String data) {
        this.layout.clear();
        this.generateLayout(data, false);
    }

    public void loadWebsite(String website) {
        if (this.allowRemoteUrls && (website.startsWith("http") || website.startsWith("https"))) {
            this.pendingUrl = website;
            return;
        }
        this.pendingWebsite = website;
    }

    public void loadUrl(String url) {
        if (this.allowRemoteUrls) {
            this.pendingUrl = url;
        }
    }

    private void setWebsite(String website) {
        String url;
        this.layout.clear();
        Matcher matcher = PATTERN_LINK.matcher(website);
        if (!matcher.matches()) {
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(null, false);
            }
            return;
        }
        this.currentWebsite = website;
        String domain = matcher.group("domain");
        String extension = matcher.group("extension");
        String directory = matcher.group("directory");
        if (directory == null) {
            url = "https://raw.githubusercontent.com/MrCrayfish/GitWeb-Sites/master/" + extension + "/" + domain + "/index";
        } else {
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            url = "https://raw.githubusercontent.com/MrCrayfish/GitWeb-Sites/master/" + extension + "/" + domain + directory + "/index";
        }
        if (this.loadingCallback != null) {
            this.loadingCallback.execute(website, true);
        }
        this.load(url);
    }

    private void setUrl(String url) {
        this.layout.clear();
        try {
            new URL(url).toURI();
        }
        catch (Exception e) {
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(null, false);
            }
            return;
        }
        this.currentWebsite = url;
        if (this.loadingCallback != null) {
            this.loadingCallback.execute(url, true);
        }
        this.load(url);
    }

    private void load(String url) {
        OnlineRequest.getInstance().make(url, (success, response) -> {
            if (success) {
                this.generateLayout(response, true);
            }
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(response, success);
            }
        });
    }

    public String getCurrentWebsite() {
        return this.currentWebsite;
    }

    private void generateLayout(String websiteData, boolean dynamic) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            List<ModuleEntry> modules = GitWebFrame.parseData(websiteData);
            if (modules == null) {
                return;
            }
            this.layout.clear();
            this.layout.height = GitWebFrame.calculateHeight(modules, this.width);
            int offset = 0;
            for (int i = 0; i < modules.size() - 1; ++i) {
                ModuleEntry entry = modules.get(i);
                Module module = entry.getModule();
                int height = module.calculateHeight(entry.getData(), this.width);
                Layout moduleLayout = new Layout(0, offset, this.width, height);
                module.generate(this, moduleLayout, this.width, entry.getData());
                this.layout.addComponent(moduleLayout);
                offset += height;
            }
            if (modules.size() > 0) {
                ModuleEntry entry = modules.get(modules.size() - 1);
                Module module = entry.getModule();
                int height = module.calculateHeight(entry.getData(), this.width);
                Layout moduleLayout = new Layout(0, offset, this.width, height);
                module.generate(this, moduleLayout, this.width, entry.getData());
                this.layout.addComponent(moduleLayout);
            }
            if (dynamic || this.initialized) {
                this.layout.handleLoad();
            }
            this.layout.resetScroll();
            this.updateListeners();
        });
    }

    private void updateListeners() {
        Text.WordListener listener = (word, mouseButton) -> {
            if (mouseButton == 0 && PATTERN_LINK.matcher(word).matches()) {
                this.pendingWebsite = word;
            }
        };
        this.addWordListener(this.layout, listener);
    }

    private void addWordListener(Layout layout, Text.WordListener listener) {
        for (Component c : layout.components) {
            if (c instanceof Layout) {
                this.addWordListener((Layout)c, listener);
                continue;
            }
            if (!(c instanceof Text)) continue;
            ((Text)c).setWordListener(listener);
        }
    }

    private static List<ModuleEntry> parseData(String websiteData) {
        websiteData = websiteData.replace("\r", "");
        LinkedList<ModuleEntry> modules = new LinkedList<ModuleEntry>();
        String[] lines = websiteData.trim().split("\\n");
        Module module = null;
        HashMap<String, String> moduleData = null;
        for (String line : lines) {
            if (line.isEmpty()) continue;
            if (line.startsWith("#")) {
                ModuleEntry entry = GitWebFrame.compileEntry(module, moduleData);
                if (entry != null) {
                    modules.add(entry);
                }
                module = MODULES.get(line.substring(1));
                moduleData = new HashMap<String, String>();
                continue;
            }
            if (module != null) {
                String[] data = line.split("=", 2);
                if (data.length != 2) {
                    return null;
                }
                moduleData.put(data[0], data[1]);
                continue;
            }
            modules.clear();
            modules.add(GitWebFrame.createPlainWebsite(websiteData));
            return modules;
        }
        ModuleEntry entry = GitWebFrame.compileEntry(module, moduleData);
        if (entry != null) {
            modules.add(entry);
        }
        return modules;
    }

    private static ModuleEntry compileEntry(Module module, Map<String, String> data) {
        if (module != null && GitWebFrame.verifyModuleEntry(module, data)) {
            return new ModuleEntry(module, data);
        }
        return null;
    }

    private static ModuleEntry createPlainWebsite(String content) {
        Module module = MODULES.get("paragraph");
        HashMap<String, String> data = new HashMap<String, String>(1, 1.0f);
        data.put("text", content);
        return new ModuleEntry(module, data);
    }

    private static boolean verifyModuleEntry(Module module, Map<String, String> data) {
        String[] requiredData;
        for (String s : requiredData = module.getRequiredData()) {
            if (data.containsKey(s)) continue;
            return false;
        }
        return true;
    }

    private static int calculateHeight(List<ModuleEntry> modules, int width) {
        int height = 0;
        for (int i = 0; i < modules.size(); ++i) {
            ModuleEntry entry = modules.get(i);
            height += entry.getModule().calculateHeight(entry.getData(), width);
        }
        return height;
    }

    public static String parseFormatting(String s) {
        return s.replace("&", "\u00a7");
    }

    public void setLoadingCallback(Callback<String> loadingCallback) {
        this.loadingCallback = loadingCallback;
    }

    public void setLoadedCallback(Callback<String> loadedCallback) {
        this.loadedCallback = loadedCallback;
    }

    public Application getApp() {
        return this.app;
    }

    public static void dumpModules(File file) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String key : MODULES.keySet()) {
                Module module = MODULES.get(key);
                writer.write("#" + key);
                writer.newLine();
                writer.write("Required Data:");
                writer.newLine();
                for (String p : module.getRequiredData()) {
                    writer.write("- " + p);
                    writer.newLine();
                }
                writer.write("Optional Data:");
                writer.newLine();
                for (String p : module.getOptionalData()) {
                    writer.write("- " + p);
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        MODULES.put("header", new HeaderModule());
        MODULES.put("footer", new FooterModule());
        MODULES.put("paragraph", new ParagraphModule());
        MODULES.put("divider", new DividerModule());
        MODULES.put("banner", new BannerModule());
        MODULES.put("navigation", new NavigationModule());
        MODULES.put("crafting", new CraftingModule());
        MODULES.put("furnace", new FurnaceModule());
        MODULES.put("brewing", new BrewingModule());
        MODULES.put("anvil", new AnvilModule());
        MODULES.put("download", new DownloadModule());
    }
}

