/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.CheckBox;
import com.mrcrayfish.device.api.app.component.ComboBox;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.renderer.ItemRenderer;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Settings;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.object.TrayItem;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.programs.system.component.Palette;
import com.mrcrayfish.device.programs.system.object.ColorScheme;
import java.awt.Color;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;

public class ApplicationSettings
extends SystemApplication {
    private Button buttonPrevious;
    private Layout layoutMain;
    private Layout layoutGeneral;
    private CheckBox checkBoxShowApps;
    private Layout layoutPersonalise;
    private Button buttonWallpaperLeft;
    private Button buttonWallpaperRight;
    private Button buttonWallpaperUrl;
    private Layout layoutColorScheme;
    private Button buttonColorSchemeApply;
    private Stack<Layout> predecessor = new Stack();

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.buttonPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        this.buttonPrevious.setVisible(false);
        this.buttonPrevious.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.predecessor.size() > 0) {
                    this.setCurrentLayout(this.predecessor.pop());
                }
                if (this.predecessor.isEmpty()) {
                    this.buttonPrevious.setVisible(false);
                }
            }
        });
        this.layoutMain = new Menu("Home");
        Button buttonColorScheme = new Button(5, 26, "Personalise", Icons.EDIT);
        buttonColorScheme.setSize(90, 20);
        buttonColorScheme.setToolTip("Personalise", "Change the wallpaper, UI colors, and more!");
        buttonColorScheme.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.layoutPersonalise = this.addWallpaperLayout();
                this.showMenu(this.layoutPersonalise);
            }
        });
        this.layoutMain.addComponent(buttonColorScheme);
        Button buttonReset = new Button(5, 100, "Reset Color Scheme");
        buttonReset.top = this.layoutMain.height - buttonReset.getHeight() - 5;
        buttonReset.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                Laptop.getSystem().getSettings().getColorScheme().resetDefault();
            }
        });
        this.layoutMain.addComponent(buttonReset);
        this.layoutGeneral = new Menu("General");
        this.layoutGeneral.addComponent(this.buttonPrevious);
        this.checkBoxShowApps = new CheckBox("Show All Apps", 5, 5);
        this.checkBoxShowApps.setSelected(Settings.isShowAllApps());
        this.checkBoxShowApps.setClickListener((mouseX, mouseY, mouseButton) -> {
            Settings.setShowAllApps(this.checkBoxShowApps.isSelected());
            Laptop laptop = this.getLaptop();
            laptop.getTaskBar().setupApplications(laptop.getApplications());
        });
        this.layoutGeneral.addComponent(this.checkBoxShowApps);
        this.layoutPersonalise = null;
        this.layoutColorScheme = new Menu("UI Colors");
        ComboBox.Custom<Integer> comboBoxTextColor = this.createColorPicker(145, 26);
        this.layoutColorScheme.addComponent(comboBoxTextColor);
        ComboBox.Custom<Integer> comboBoxTextSecondaryColor = this.createColorPicker(145, 44);
        this.layoutColorScheme.addComponent(comboBoxTextSecondaryColor);
        ComboBox.Custom<Integer> comboBoxHeaderColor = this.createColorPicker(145, 62);
        this.layoutColorScheme.addComponent(comboBoxHeaderColor);
        ComboBox.Custom<Integer> comboBoxBackgroundColor = this.createColorPicker(145, 80);
        this.layoutColorScheme.addComponent(comboBoxBackgroundColor);
        ComboBox.Custom<Integer> comboBoxBackgroundSecondaryColor = this.createColorPicker(145, 98);
        this.layoutColorScheme.addComponent(comboBoxBackgroundSecondaryColor);
        ComboBox.Custom<Integer> comboBoxItemBackgroundColor = this.createColorPicker(145, 116);
        this.layoutColorScheme.addComponent(comboBoxItemBackgroundColor);
        ComboBox.Custom<Integer> comboBoxItemHighlightColor = this.createColorPicker(145, 134);
        this.layoutColorScheme.addComponent(comboBoxItemHighlightColor);
        this.buttonColorSchemeApply = new Button(5, 79, Icons.CHECK);
        this.buttonColorSchemeApply.setEnabled(false);
        this.buttonColorSchemeApply.setToolTip("Apply", "Set these colors as the new color scheme");
        this.buttonColorSchemeApply.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                ColorScheme colorScheme = Laptop.getSystem().getSettings().getColorScheme();
                colorScheme.setBackgroundColor((Integer)comboBoxHeaderColor.getValue());
                this.buttonColorSchemeApply.setEnabled(false);
            }
        });
        this.layoutColorScheme.addComponent(this.buttonColorSchemeApply);
        this.setCurrentLayout(this.layoutMain);
    }

    private Layout addWallpaperLayout() {
        Menu wallpaperLayout = new Menu("Wallpaper");
        Image image = new Image(6, 29, 128, 99);
        image.setBorderThickness(1);
        image.setBorderVisible(true);
        assert (this.getLaptop() != null);
        image.setImage(this.getLaptop().getCurrentWallpaper());
        wallpaperLayout.addComponent(image);
        this.buttonWallpaperLeft = new Button(135, 27, Icons.ARROW_LEFT);
        this.buttonWallpaperLeft.setSize(25, 20);
        this.buttonWallpaperLeft.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.prevWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.buttonWallpaperLeft.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.buttonWallpaperLeft);
        this.buttonWallpaperRight = new Button(165, 27, Icons.ARROW_RIGHT);
        this.buttonWallpaperRight.setSize(25, 20);
        this.buttonWallpaperRight.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.nextWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.buttonWallpaperRight.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.buttonWallpaperRight);
        Button resetWallpaperBtn = new Button(6, 100, "Reset Wallpaper");
        resetWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.getLaptop().setWallpaper(0);
                image.setImage(this.getLaptop().getCurrentWallpaper());
                this.buttonWallpaperLeft.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                this.buttonWallpaperRight.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
            }
        });
        resetWallpaperBtn.top = wallpaperLayout.height - resetWallpaperBtn.getHeight() - 5;
        wallpaperLayout.addComponent(resetWallpaperBtn);
        wallpaperLayout.addComponent(this.buttonPrevious);
        this.buttonWallpaperUrl = new Button(135, 52, "Load", Icons.EARTH);
        this.buttonWallpaperUrl.setSize(55, 20);
        this.buttonWallpaperUrl.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Dialog.Input dialog = new Dialog.Input("Enter the URL of the image");
            dialog.setResponseHandler((success, string) -> {
                if (this.getLaptop() != null) {
                    this.getLaptop().setWallpaper((String)string);
                    image.setImage(this.getLaptop().getCurrentWallpaper());
                    this.buttonWallpaperLeft.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                    this.buttonWallpaperRight.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                }
                return success;
            });
            this.openDialog(dialog);
        });
        wallpaperLayout.addComponent(this.buttonWallpaperUrl);
        Text wallpaperText = new Text("Wallpaper", image.left + 3, image.top + 3, image.componentWidth - 6);
        wallpaperText.setShadow(true);
        wallpaperText.setTextColor(new Color(this.getLaptop().getSettings().getColorScheme().getTextColor()));
        wallpaperLayout.addComponent(wallpaperText);
        wallpaperLayout.addComponent(this.buttonPrevious);
        return wallpaperLayout;
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    private void showMenu(Layout layout) {
        this.predecessor.push(this.getCurrentLayout());
        this.buttonPrevious.setVisible(true);
        this.setCurrentLayout(layout);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.predecessor.clear();
    }

    public ComboBox.Custom<Integer> createColorPicker(int left, int top) {
        ComboBox.Custom<Integer> colorPicker = new ComboBox.Custom<Integer>(left, top, 50, 100, 100);
        colorPicker.setValue(Color.RED.getRGB());
        colorPicker.setItemRenderer(new ItemRenderer<Integer>(){

            @Override
            public void render(Integer integer, Gui gui, Minecraft mc, int x, int y, int width, int height) {
                if (integer != null) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)integer);
                }
            }
        });
        colorPicker.setChangeListener((oldValue, newValue) -> this.buttonColorSchemeApply.setEnabled(true));
        Palette palette = new Palette(5, 5, colorPicker);
        Layout.Context layout = colorPicker.getLayout();
        layout.addComponent(palette);
        return colorPicker;
    }

    public static class SettingsTrayItem
    extends TrayItem {
        public SettingsTrayItem() {
            super(Icons.WRENCH);
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication("cdm:settings");
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }

    private static class Menu
    extends Layout {
        private String title;

        public Menu(String title) {
            super(200, 150);
            this.title = title;
        }

        @Override
        public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
            Gui.func_73734_a((int)x, (int)y, (int)(x + this.width), (int)(y + 20), (int)color.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 20), (int)(x + this.width), (int)(y + 21), (int)color.darker().getRGB());
            mc.field_71466_p.func_175065_a(this.title, (float)(x + 22), (float)(y + 6), Color.WHITE.getRGB(), true);
            super.render(laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        }
    }
}

