/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.block.BlockPrinter;
import com.mrcrayfish.device.init.DeviceSounds;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import com.mrcrayfish.device.util.CollisionHelper;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;

public class TileEntityPrinter
extends TileEntityNetworkDevice.Colored {
    private State state = State.IDLE;
    private Deque<IPrint> printQueue = new ArrayDeque<IPrint>();
    private IPrint currentPrint;
    private int totalPrintTime;
    private int remainingPrintTime;
    private int paperCount = 0;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.remainingPrintTime > 0) {
                if (this.remainingPrintTime % 20 == 0 || this.state == State.LOADING_PAPER) {
                    this.pipeline.func_74768_a("remainingPrintTime", this.remainingPrintTime);
                    this.sync();
                    if (this.remainingPrintTime != 0 && this.state == State.PRINTING) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, DeviceSounds.PRINTER_PRINTING, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
                --this.remainingPrintTime;
            } else {
                this.setState(this.state.next());
            }
        }
        if (this.state == State.IDLE && this.remainingPrintTime == 0 && this.currentPrint != null) {
            if (!this.field_145850_b.field_72995_K) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                double[] fixedPosition = CollisionHelper.fixRotation((EnumFacing)state.func_177229_b((IProperty)BlockPrinter.field_185512_D), 0.15, 0.5, 0.15, 0.5);
                EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + fixedPosition[0], (double)this.field_174879_c.func_177956_o() + 0.0625, (double)this.field_174879_c.func_177952_p() + fixedPosition[1], IPrint.generateItem(this.currentPrint));
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)entity);
            }
            this.currentPrint = null;
        }
        if (this.state == State.IDLE && this.currentPrint == null && !this.printQueue.isEmpty() && this.paperCount > 0) {
            this.print(this.printQueue.poll());
        }
    }

    @Override
    public String getDeviceName() {
        return "Printer";
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("currentPrint", 10)) {
            this.currentPrint = IPrint.loadFromTag(compound.func_74775_l("currentPrint"));
        }
        if (compound.func_150297_b("totalPrintTime", 3)) {
            this.totalPrintTime = compound.func_74762_e("totalPrintTime");
        }
        if (compound.func_150297_b("remainingPrintTime", 3)) {
            this.remainingPrintTime = compound.func_74762_e("remainingPrintTime");
        }
        if (compound.func_150297_b("state", 3)) {
            this.state = State.values()[compound.func_74762_e("state")];
        }
        if (compound.func_150297_b("paperCount", 3)) {
            this.paperCount = compound.func_74762_e("paperCount");
        }
        if (compound.func_150297_b("queue", 9)) {
            this.printQueue.clear();
            NBTTagList queue = compound.func_150295_c("queue", 10);
            for (int i = 0; i < queue.func_74745_c(); ++i) {
                IPrint print = IPrint.loadFromTag(queue.func_150305_b(i));
                this.printQueue.offer(print);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("totalPrintTime", this.totalPrintTime);
        compound.func_74768_a("remainingPrintTime", this.remainingPrintTime);
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74768_a("paperCount", this.paperCount);
        if (this.currentPrint != null) {
            compound.func_74782_a("currentPrint", (NBTBase)IPrint.writeToTag(this.currentPrint));
        }
        if (!this.printQueue.isEmpty()) {
            NBTTagList queue = new NBTTagList();
            this.printQueue.forEach(print -> queue.func_74742_a((NBTBase)IPrint.writeToTag(print)));
            compound.func_74782_a("queue", (NBTBase)queue);
        }
        return compound;
    }

    @Override
    public NBTTagCompound writeSyncTag() {
        NBTTagCompound tag = super.writeSyncTag();
        tag.func_74768_a("paperCount", this.paperCount);
        return tag;
    }

    public void setState(State newState) {
        if (newState == null) {
            return;
        }
        this.state = newState;
        this.remainingPrintTime = this.state == State.PRINTING ? (DeviceConfig.isOverridePrintSpeed() ? DeviceConfig.getCustomPrintSpeed() * 20 : this.currentPrint.speed() * 20) : this.state.animationTime;
        this.totalPrintTime = this.remainingPrintTime;
        this.pipeline.func_74768_a("state", this.state.ordinal());
        this.pipeline.func_74768_a("totalPrintTime", this.totalPrintTime);
        this.pipeline.func_74768_a("remainingPrintTime", this.remainingPrintTime);
        this.sync();
    }

    public void addToQueue(IPrint print) {
        this.printQueue.offer(print);
    }

    private void print(IPrint print) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, DeviceSounds.PRINTER_LOADING_PAPER, SoundCategory.BLOCKS, 0.5f, 1.0f);
        this.setState(State.LOADING_PAPER);
        this.currentPrint = print;
        --this.paperCount;
        this.pipeline.func_74768_a("paperCount", this.paperCount);
        this.pipeline.func_74782_a("currentPrint", (NBTBase)IPrint.writeToTag(this.currentPrint));
        this.sync();
    }

    public boolean isLoading() {
        return this.state == State.LOADING_PAPER;
    }

    public boolean isPrinting() {
        return this.state == State.PRINTING;
    }

    public int getTotalPrintTime() {
        return this.totalPrintTime;
    }

    public int getRemainingPrintTime() {
        return this.remainingPrintTime;
    }

    public boolean addPaper(ItemStack stack, boolean addAll) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151121_aF && this.paperCount < DeviceConfig.getMaxPaperCount()) {
            if (!addAll) {
                ++this.paperCount;
                stack.func_190918_g(1);
            } else {
                this.paperCount += stack.func_190916_E();
                stack.func_190920_e(Math.max(0, this.paperCount - 64));
                this.paperCount = Math.min(64, this.paperCount);
            }
            this.pipeline.func_74768_a("paperCount", this.paperCount);
            this.sync();
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187623_cM, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean hasPaper() {
        return this.paperCount > 0;
    }

    public int getPaperCount() {
        return this.paperCount;
    }

    public IPrint getPrint() {
        return this.currentPrint;
    }

    public static enum State {
        LOADING_PAPER(30),
        PRINTING(0),
        IDLE(0);

        final int animationTime;

        private State(int time) {
            this.animationTime = time;
        }

        public State next() {
            if (this.ordinal() + 1 >= State.values().length) {
                return null;
            }
            return State.values()[this.ordinal() + 1];
        }
    }
}

