/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity.render;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.api.print.PrintingManager;
import com.mrcrayfish.device.block.BlockPaper;
import com.mrcrayfish.device.init.DeviceBlocks;
import com.mrcrayfish.device.tileentity.TileEntityPaper;
import com.mrcrayfish.device.tileentity.render.PrinterRenderer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PaperRenderer
extends TileEntitySpecialRenderer<TileEntityPaper> {
    public void render(TileEntityPaper te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        NBTTagCompound data;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != DeviceBlocks.PAPER) {
            return;
        }
        GlStateManager.func_179114_b((float)((float)((EnumFacing)state.func_177229_b((IProperty)BlockPaper.field_185512_D)).func_176736_b() * -90.0f + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-te.getRotation()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        IPrint print = te.getPrint();
        if (print != null && (data = print.toTag()).func_150297_b("pixels", 11) && data.func_150297_b("resolution", 3)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PrinterRenderer.ModelPaper.TEXTURE);
            if (DeviceConfig.isRenderPrinted3D() && !data.func_74767_n("cut")) {
                PaperRenderer.drawCuboid(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(DeviceConfig.isRenderPrinted3D() ? 0.0625 : 0.001));
            GlStateManager.func_179094_E();
            IPrint.Renderer renderer = PrintingManager.getRenderer(print);
            renderer.render(data);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            if (DeviceConfig.isRenderPrinted3D() && data.func_74767_n("cut")) {
                NBTTagCompound tag = print.toTag();
                PaperRenderer.drawPixels(tag.func_74759_k("pixels"), tag.func_74762_e("resolution"), tag.func_74767_n("cut"));
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private static void drawCuboid(double x, double y, double z, double width, double height, double depth) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        PaperRenderer.drawQuad(x + (1.0 - (width /= 16.0)), y /= 16.0, z /= 16.0, (x /= 16.0) + width + (1.0 - width), y + (height /= 16.0), z, EnumFacing.NORTH);
        PaperRenderer.drawQuad(x + 1.0, y, z, x + 1.0, y + height, z + (depth /= 16.0), EnumFacing.EAST);
        PaperRenderer.drawQuad(x + width + 1.0 - (width + width), y, z + depth, x + width + 1.0 - (width + width), y + height, z, EnumFacing.WEST);
        PaperRenderer.drawQuad(x + (1.0 - width), y, z + depth, x + width + (1.0 - width), y, z, EnumFacing.DOWN);
        PaperRenderer.drawQuad(x + (1.0 - width), y + height, z, x + width + (1.0 - width), y, z + depth, EnumFacing.UP);
        GlStateManager.func_179101_C();
        GlStateManager.func_179145_e();
    }

    private static void drawQuad(double xFrom, double yFrom, double zFrom, double xTo, double yTo, double zTo, EnumFacing facing) {
        double textureWidth = Math.abs(xTo - xFrom);
        double textureHeight = Math.abs(yTo - yFrom);
        double textureDepth = Math.abs(zTo - zFrom);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        switch (facing.func_176740_k()) {
            case X: {
                buffer.func_181662_b(xFrom, yFrom, zFrom).func_187315_a(1.0 - xFrom + textureDepth, 1.0 - yFrom + textureHeight).func_181675_d();
                buffer.func_181662_b(xFrom, yTo, zFrom).func_187315_a(1.0 - xFrom + textureDepth, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yTo, zTo).func_187315_a(1.0 - xFrom, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yFrom, zTo).func_187315_a(1.0 - xFrom, 1.0 - yFrom + textureHeight).func_181675_d();
                break;
            }
            case Y: {
                buffer.func_181662_b(xFrom, yFrom, zFrom).func_187315_a(1.0 - xFrom + textureWidth, 1.0 - yFrom + textureDepth).func_181675_d();
                buffer.func_181662_b(xFrom, yFrom, zTo).func_187315_a(1.0 - xFrom + textureWidth, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yFrom, zTo).func_187315_a(1.0 - xFrom, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yFrom, zFrom).func_187315_a(1.0 - xFrom, 1.0 - yFrom + textureDepth).func_181675_d();
                break;
            }
            case Z: {
                buffer.func_181662_b(xFrom, yFrom, zFrom).func_187315_a(1.0 - xFrom + textureWidth, 1.0 - yFrom + textureHeight).func_181675_d();
                buffer.func_181662_b(xFrom, yTo, zFrom).func_187315_a(1.0 - xFrom + textureWidth, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yTo, zTo).func_187315_a(1.0 - xFrom, 1.0 - yFrom).func_181675_d();
                buffer.func_181662_b(xTo, yFrom, zTo).func_187315_a(1.0 - xFrom, 1.0 - yFrom + textureHeight).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    private static void drawPixels(int[] pixels, int resolution, boolean cut) {
        double scale = 16.0 / (double)resolution;
        for (int i = 0; i < resolution; ++i) {
            for (int j = 0; j < resolution; ++j) {
                float a = (float)Math.floor((float)(pixels[j + i * resolution] >> 24 & 0xFF) / 255.0f);
                if (a < 1.0f) {
                    if (cut) continue;
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    float r = (float)(pixels[j + i * resolution] >> 16 & 0xFF) / 255.0f;
                    float g = (float)(pixels[j + i * resolution] >> 8 & 0xFF) / 255.0f;
                    float b = (float)(pixels[j + i * resolution] & 0xFF) / 255.0f;
                    GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                }
                PaperRenderer.drawCuboid((double)j * scale - (double)(resolution - 1) * scale, (double)(-i) * scale + (double)(resolution - 1) * scale, -1.0, scale, scale, 1.0);
            }
        }
    }
}

